#!/usr/bin/perl -s
use strict;

sub update_ncbi_lproks_win {
    print "Content-type: text/html\n";
    print "\n";

    my($dir) = "$ENV{'RECOG_HOME'}/database.work";
    my($file_ncbi_lproks) = "$dir/ncbi_lproks.txt";
    my($tm_ncbi_lproks) = 'Not found';
    if (-e $file_ncbi_lproks) {
        my(@stat_list) = stat($file_ncbi_lproks);
        my($sec, $min, $hour, $mday, $mon, $year) = localtime($stat_list[9]);
        $year += 1900;
        $mon++;
        $tm_ncbi_lproks = sprintf("%04d/%02d/%02d", $year, $mon, $mday);
    }

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>

<body>

<div id="id_msg">
<h1>Update NCBI lproks</h1>
Download NCBI lproks from <a href="http://www.ncbi.nlm.nih.gov/genomes/lproks.cgi?dump=selected">ftp.ncbi.nih.gov</a><br />
<p>
timestamp : $tm_ncbi_lproks<br>
</div>

<form name="frm_update_ncbi_lproks" method="post">
<input type="button" name="btn_update_ncbi_lproks" value="Update" onclick="update_ncbi_lproks();">
</form>
</body>
</html>
EOB

    return;
}

################################################################################
if ($0 eq __FILE__) {
    update_ncbi_lproks_win();
}
1;#
