#!/usr/bin/perl -s
use strict;

sub update_public_species_win {
    print "Content-type: text/html\n";
    print "\n";

    my($dir) = "$ENV{'RECOG_HOME'}/etc";
    my($file_spid) = "$dir/spid.tab.dist";
    my($tm_spid) = 'Not found';
    if (-e $file_spid) {
        my(@stat_list) = stat($file_spid);
        my($sec, $min, $hour, $mday, $mon, $year) = localtime($stat_list[9]);
        $year += 1900;
        $mon++;
        $tm_spid = sprintf("%04d/%02d/%02d", $year, $mon, $mday);
    }

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>

<body>

<div id="id_msg">
<h1>Update public species</h1>
Download species list from <a href="http://mbgd.genome.ad.jp/data/species/spid.tab">mbgd.genome.ad.jp</a><br />
<p>
timestamp : $tm_spid<br>
</div>

<form name="frm_update_public_species" method="post">
<input type="button" name="btn_update_public_species" value="Update" onclick="update_public_species();">
</form>
</body>
</html>
EOB

    return;
}

################################################################################
if ($0 eq __FILE__) {
    update_public_species_win();
}
1;#
