#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
require "MBGD_Conf.pl";
require "InfoSpec.pl";

###############################################################################
sub print_html_header {
    my($pid) = shift;
    my($t) = shift;

    my($html_reload) = '';
    if (0 < $t) {
        my($uri) = qq{/htbin/recog_build/update_taxonomy.cgi?pid=$pid&t=$t};
        $html_reload = qq{<meta http-equiv="refresh" content="$t;URL=$uri">};
    }

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
$html_reload
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>
EOB

    return;
}

###############################################################################
sub print_html_running {
    my($pid) = shift;
    my($t) = shift;

    if ($t < 5) {
        $t = 5;
    }

    print_html_header($pid, $t);

    print <<EOB;
<body>
<h1>Update taxonomy</h1>
<h2>Running...</h2>
</body>
</html>
EOB

    return;
}

###############################################################################
sub print_html_finished {
    my($msg) = shift;

    print_html_header();

    my($html_msg) = '';
    if ($msg) {
        $html_msg = '<h3>Found error(s)</h3>' . $msg;
    }

    print <<EOB;
<h1>Update taxonomy</h1>
<h2>Done.</h2>
$html_msg
</body>
</html>
EOB

    return;
}

###############################################################################
sub update_taxonomy {
    my($formOpt) = shift;

    #
    my($file_pid) = "$ENV{'RECOG_HOME'}/etc/taxdump.pid";
    my($file_err) = "$ENV{'RECOG_HOME'}/etc/taxdump.err";
    my($t) = $formOpt->{'t'};
    $t = int($t * 1.2);
    if (60 < $t) {
        $t = 60;
    }

    #
    my($pid) = $formOpt->{'pid'};
    if ($pid) {
        my($sta) = kill(0 => $pid);
        if ($sta) {
            # running!
            print_html_running($pid, $t);
        }
        else {
            # finished
            my($msg) = '';
            if (-e $file_err) {
                # Found err
                my($fh) = FileHandle->new("$file_err");
                $msg = join("<br>", $fh->getlines());
                $fh->close();
            }
            print_html_finished($msg);
        }
        exit(0);
    }

    #
    if (-e $file_pid) {
        my($fh) = FileHandle->new("$file_pid") || die("Can not open $file_pid($!)");
        $pid = $fh->getline();
        $pid =~ s#[\r\n]*$##;
        $fh->close();

        my($sta) = kill(0 => $pid);
        if (!$sta) {
            # NOT found :: PID=$pid
            unlink("$file_pid");
        }
        else {
            print_html_running($pid, $t);
            exit(0);
        }
    }

    #
    my($pid) = fork();
    if ($pid) {
        sleep(2);
        print_html_running($pid, $t);
        exit(0);
    }

    #
    close(STDIN);
    close(STDOUT);
    close(STDERR);

    #
    if (!-e $file_pid) {
        my($fh) = FileHandle->new(">$file_pid") || die("Can not open $file_pid($!)");
        $fh->print($$, "\n");
        $fh->close();
    }

    #
    my($dir) = "$ENV{'RECOG_HOME'}/work/update_taxonomy.$$";
    mkpath($dir, 0, 0750);

    #
    my($file_taxdump) = "$ENV{'RECOG_HOME'}/etc/taxdump.tar.gz";
    my($uri) = 'ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz';
    my($cmd) = "$main::CMD_curl -s -L -z $file_taxdump -o $file_taxdump $uri";
    my($sta);
    for (my$i=0; $i < 5; $i++) {
        $sta = system("$cmd");
        if ($sta == 0) {
            last;
        }
        sleep(15);
    }
    if (($sta >> 8) != 0) {
        rmtree("$dir");
        unlink("$file_pid");
        my($fh) = FileHandle->new(">$file_err");
        $fh->print("ERROR :: $cmd\n");
        $fh->print("STATUS :: ", $sta, "\n");
        $fh->print("STATUS :: ", $sta>>8, "\n");
        $fh->close();
        return;
    }

    #
print STDERR "extract taxonomy data\n";
    chdir($dir);
    my($cmd) = "$main::CMD_tar xfz $file_taxdump > /dev/null 2>&1";
    my($sta) = system("$cmd");
    if (($sta >> 8) != 0) {
        rmtree("$dir");
        unlink("$file_pid");
        my($fh) = FileHandle->new(">$file_err");
        $fh->print("ERROR :: $cmd\n");
        $fh->print("STATUS :: $sta\n");
        $fh->close();
        return;
    }

    #
    my($file_tax) = "$ENV{'RECOG_HOME'}/etc/taxon.tab";
    my($file_tmp) = "$ENV{'RECOG_HOME'}/etc/taxon.tmp.$$";
    my($file_new) = "$ENV{'RECOG_HOME'}/etc/taxon.tab.$$";
    my($cmd) = "$main::DIR_build/convTaxonomyDb.pl -DIRNAME=$dir > $file_tmp ; $main::CMD_sort -t'\t' -k8n $file_tmp > $file_new";
    my($sta) = system("$cmd");
    if (($sta >> 8) != 0) {
        rmtree("$dir");
        unlink("$file_pid");
        unlink("$file_tmp");
        my($fh) = FileHandle->new(">$file_err");
        $fh->print("ERROR :: $cmd\n");
        $fh->close();
        return;
    }

    #
    my($cmd) = "$main::CMD_mv $file_new $file_tax";
    my($sta) = system("$cmd");

    #
    my($fileSpidDist) = "$main::FILE_spidtab.dist";
    my($refSpidDist) = getInfoSpecTab($fileSpidDist);
    my($spec) = keys(%{$refSpidDist->{'NAME2SPID'}});
    my($dir_etc) = "$ENV{'MBGD_HOME'}/etc";
    my($dir_public_server) = $dir_etc . '/' . $main::NAME_PUBLIC_SERVER;
    my($file_tax) = "$dir_public_server/tax";
    my($cmd) = "$ENV{'RECOG_HOME'}/build/m1150UpdateTaxTree.pl -USE_FILE -OUT=$file_tax";
    my($sta) = system("$cmd");

    # copy tax
    my($dir_etc) = "$ENV{'RECOG_HOME'}/etc";
    my($dir_work) = "$ENV{'RECOG_HOME'}/work";
    foreach my$dir ($dir_etc, $dir_work) {
        foreach my$ext ('', '.map') {
            my($cmd) = "$main::CMD_cp -p $file_tax$ext $dir";
            system("$cmd");
        }
    }

    #
    my($file_tab_gold) = "$dir_public_server/tab_gold.txt";
    my($uri) = $main::URL_PUBLIC_SERVER . '/htbin/getData?table=gold';
    my($cmd) = "$main::CMD_curl -L '$uri' > $file_tab_gold";
    system("$cmd");

    #
    my($file_tab_gold_mbgd) = "$dir_public_server/tab_gold_mbgd.txt";
    my($uri) = $main::URL_PUBLIC_SERVER . '/htbin/getData?table=gold_mbgd';
    my($cmd) = "$main::CMD_curl -L '$uri' > $file_tab_gold_mbgd";
    system("$cmd");

    #
    my($file_taball) = "$ENV{'RECOG_HOME'}/etc/taball.dist";
    my($uri) = "$main::URL_PUBLIC_SERVER/htbin/RECOG/getData?table=taball";
    my($cmd) = "$main::CMD_curl -s -L -o $file_taball.$$ '$uri'";
    my($sta);
    for (my$i=0; $i < 5; $i++) {
        $sta = system("$cmd");
        if ($sta == 0) {
            my($cmd) = "$main::CMD_mv $file_taball.$$ $file_taball";
            system("$cmd");
            last;
        }
        sleep(2);
    }
    if (($sta >> 8) != 0) {
        rmtree("$dir");
        unlink("$file_pid");
        my($fh) = FileHandle->new(">$file_err");
        $fh->print("ERROR :: $cmd\n");
        $fh->print("STATUS :: ", $sta, "\n");
        $fh->print("STATUS :: ", $sta>>8, "\n");
        $fh->close();
        return;
    }

    #
    rmtree("$dir");
    unlink($file_pid);
    unlink($file_tmp);
    unlink($file_err);

    return;
}

################################################################################
if ($0 eq __FILE__) {
    my($cgi)  = CGI->new();

    my($formOpt) = {};
    foreach my$key ('pid', 't') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    update_taxonomy($formOpt);
}
1;#
