#!/usr/bin/perl -s
use strict;

sub update_taxonomy_win {
    print "Content-type: text/html\n";
    print "\n";

    my($file_taxdump) = "$ENV{'RECOG_HOME'}/etc/taxdump.tar.gz";
    my($tm_taxdump) = 'Not found';
    if (-e $file_taxdump) {
        my(@stat_list) = stat($file_taxdump);
        my($sec, $min, $hour, $mday, $mon, $year) = localtime($stat_list[9]);
        $year += 1900;
        $mon++;
        $tm_taxdump = sprintf("%04d/%02d/%02d", $year, $mon, $mday);
    }

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>

<body>

<div id="id_msg">
<h1>Update taxonomy</h1>
Download taxonomy from <a href="ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz">ftp.ncbi.nih.gov</a><br />
<p>
timestamp : $tm_taxdump<br>
</div>

<form name="frm_update_taxonomy" method="post">
<input type="button" name="btn_update_taxonomy" value="Update" onclick="update_taxonomy();">
</form>
</body>
</html>
EOB

    return;
}

################################################################################
if ($0 eq __FILE__) {
    update_taxonomy_win();
}
1;#
