#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub del_gene_prop {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        #
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($prop_name) = $form_opt->{'prop_name'};
    my(@spec_list) = split(/,/, $form_opt->{'spec'});
    RecogProjectCommon::delete_gene_prop($db, $prop_name, @spec_list);

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('prop_name', 'spec');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    del_gene_prop($form_opt);
}

###############################################################################
1;#
###############################################################################
