#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG::RecogProject;
use RECOG::DomClustCommon;
use RecogProjectCommon;
require 'libMBGDaxes.pl';

###############################################################################
sub edit_base_cluster {
    my($form_opt) = shift;
    my($refSelectOpt) = shift;
    my($refDomclustOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};
    my($bc_id) = $form_opt->{'base_cluster_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($proj_ref) = $auth->load_project($user, $project_id);
    my($dir_proj) = "$ENV{'RECOG_HOME'}/etc/projects/$project_id.d";

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Edit base cluster condition</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    if (!$bc_id) {
        for ($bc_id = 1; ; $bc_id++) {
            my($file_sel_conf) = "$dir_proj/$bc_id.sel";
            if (! -e $file_sel_conf) {
                last;
            }
        }
    }

    #
    my($file_sel_conf) = "$dir_proj/$bc_id.sel";
    RecogProjectCommon::save_bc_sel_conf($file_sel_conf, $refSelectOpt);

    #
    my($file_dom_conf) = "$dir_proj/$bc_id.dom";
    RecogProjectCommon::save_bc_dom_conf($file_dom_conf, $refDomclustOpt);





    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('project_id', 'base_cluster_id') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    my($refSelectOpt)   = parseSelectOpt($cgi);
    my($refDomclustOpt) = parseDomClustOpt($cgi);

    edit_base_cluster($form_opt, $refSelectOpt, $refDomclustOpt);
}

###############################################################################
1;#
###############################################################################
