#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RECOG::DomClustCommon;
use RECOG::RecogCommon;
use RecogProjectCommon;

###############################################################################
#
sub list_project_domclust {
    my($db) = shift;
    my($proj_id) = shift;
    my(@key_list) = ( 'proj_id', 'clusttabid',
                      'name', 'descr',
                      'cmd',
                      'cdate');

    #
    my(@args);
    my($cols)  = "p.proj_id, p.clusttabid, p.name as name, p.descr as descr, i.cmd as cmd, i.cdate as cdate";
    my($tab)   = "project_domclust p left join cluster_tables_idx i on p.clusttabid=i.clusterID";
    my($where) = "1";
    if ($proj_id) {
        $where .= " and proj_id=?";
        push(@args, $proj_id);
    }
    my($order) = "proj_id, clusttabid";
    my($sql)   = "select $cols from $tab where $where order by $order";

    my($sth) = $db->prepare($sql);
    $sth->execute(@args);

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);
    print "#", join("\t", @key_list), "\n";
    while (my$ref=$sth->fetchrow_hashref()) {
        my(@dat) = ();
        foreach my$k (@key_list) {
            my($v) = $ref->{"$k"};
            if ($k eq 'cmd') {
                my($opt_sel) = {};
                my($opt_dom) = {};
                my(@spec_list) = RECOG::RecogCommon::rebuild_domclust_options($db, $ref->{'clusttabid'}, $opt_sel, $opt_dom);
                $v = '';
                if (scalar(@spec_list) != 0) {
                    $v = 'species=' . join(',', @spec_list);

                    #
                    my(%spec_hash);
                    foreach my$spec (@spec_list) {
                        $spec_hash{"$spec"} = 1;
                    }
                    foreach my$spec (split(/\,/, $opt_dom->{'-Ooutgroup'})) {
                        delete($spec_hash{"$spec"});
                    }
                    my(@spec_ingroup) = keys(%spec_hash);
                    $v .= '&ingroup=' . join(',', @spec_ingroup);

                }
                my($v_sel) = sprint_select_opt($opt_sel);
                if ($v_sel) {
                    $v .= '&' if ($v);
                    $v .= $v_sel;
                }
                my($v_dom) = sprint_domclust_opt($opt_dom);
                if ($v_dom) {
                    $v .= '&' if ($v);
                    $v .= $v_dom;
                }
            }
#            $v =~ s#([^a-z0-9])#sprintf("%%%02x", ord($1))#gei;
            push(@dat, $v);
        }
        print join("\t", @dat), "\n";
    }

    return;
}

###############################################################################
#
sub list_project_phylopat {
    my($db) = shift;
    my($proj_id) = shift;
    my(@key_list) = ( 'proj_id', 'clusttabid', 'phylopatid',
                      'name', 'descr',
                      'cmd',
                      'cdate');

    #
    my(@args);
    my($cols)  = "p.proj_id, p.clusttabid, p.phylopatid, p.name as name, p.descr as descr, i.cmd as cmd, i.cdate as cdate";
    my($tab)   = "project_phylopat p left join cluster_tables_idx_phylopat i on p.phylopatid=i.clust_tab_id";
    my($where) = "1";
    if ($proj_id) {
        $where .= " and proj_id=?";
        push(@args, $proj_id);
    }
    my($order) = "proj_id, clusttabid, phylopatid";
    my($sql)   = "select $cols from $tab where $where order by $order";

    my($sth) = $db->prepare($sql);
    $sth->execute(@args);

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);
    print "#", join("\t", @key_list), "\n";
    while (my$ref=$sth->fetchrow_hashref()) {
        my(@dat) = ();
        foreach my$k (@key_list) {
            my($v) = $ref->{"$k"};
            $v =~ s#([^a-z0-9])#sprintf("%%%02x", ord($1))#gei;
            push(@dat, $v);
        }
        print join("\t", @dat), "\n";
    }

    return;
}

###############################################################################
#
sub list_project_core {
    my($db) = shift;
    my($proj_id) = shift;
    my(@key_list) = ( 'proj_id', 'clusttabid', 'coreid',
                      'name', 'descr',
                      'cmd',
                      'cdate');

    #
    my(@args);
    my($cols)  = "p.proj_id, p.clusttabid, p.coreid, p.name as name, p.descr as descr, i.cmd as cmd, i.cdate as cdate";
    my($tab)   = "project_core p left join core_tables_idx i on p.coreid=i.core_tab_id";
    my($where) = "1";
    if ($proj_id) {
        $where .= " and proj_id=?";
        push(@args, $proj_id);
    }
    my($order) = "proj_id, clusttabid, coreid";
    my($sql)   = "select $cols from $tab where $where order by $order";

    my($sth) = $db->prepare($sql);
    $sth->execute(@args);

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);
    print "#", join("\t", @key_list), "\n";
    if ($sth->rows() == 0) {
        return;
    }

    #
    while (my$ref=$sth->fetchrow_hashref()) {
        my(@dat) = ();
        foreach my$k (@key_list) {
            my($v) = $ref->{"$k"};
            $v =~ s#([^a-z0-9])#sprintf("%%%02x", ord($1))#gei;
            push(@dat, $v);
        }
        print join("\t", @dat), "\n";
    }

    return;
}

###############################################################################
#
sub list_project_cluster {
    my($form_opt) = shift;
    my($user_name) = $ENV{'REMOTE_USER'};

    #
    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    #
    my($uid) = RecogProjectCommon::exists_user_name($user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        # print no data
        return;
    }

    #
    my($type) = $form_opt->{'type'};
    my($proj_id) = $form_opt->{'proj_id'};
    $proj_id = RecogProjectCommon::conv_proj_id($proj_id);

    #
    if ($type =~ /^phylopat$/i) {
        list_project_phylopat($db, $proj_id);
    }
    elsif ($type =~ /^core$/i) {
        list_project_core($db, $proj_id);
    }
    else { # default = 'domclust'
        list_project_domclust($db, $proj_id);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('proj_id', 'type');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    list_project_cluster($form_opt);
}

###############################################################################
1;#
###############################################################################
