#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RECOG::DomClustCommon;
use RECOG::RecogCommon;
use RecogProjectCommon;

###############################################################################
#
sub list_project_domclust {
    my($db) = shift;
    my($proj_id) = shift;
    my(@key_list) = ( 'proj_id', 'clusttabid',
                      'name', 'descr',
                      'cmd',
                      'cdate');

    #
    my(@args);
    my($cols)  = "p.proj_id, p.clusttabid, p.name as name, p.descr as descr, i.cmd as cmd, i.cdate as cdate";
    my($tab)   = "project_domclust p left join cluster_tables_idx i on p.clusttabid=i.clusterID";
    my($where) = "1";
    if ($proj_id) {
        $where .= " and proj_id=?";
        push(@args, $proj_id);
    }
    my($order) = "proj_id, clusttabid";
    my($sql)   = "select $cols from $tab where $where order by $order";

    my($sth) = $db->prepare($sql);
    $sth->execute(@args);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOB;
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script>
function delete_domclust(proj_id, clusttab_id, name) {
    var doc = this.document;
    var frm = doc.frm_list_domclust;

    var sta = confirm('Delete this result?');
    if (!sta) {
        return;
    }

    frm.type.value       = 'domclust';
    frm.proj_id.value    = proj_id;
    frm.clusttabid.value = clusttab_id;
    frm.name.value       = name;

    //
    frm.target = 'win_' + proj_id + '_' + clusttab_id;
    frm.action = '/htbin/recog_project/delete_project_cluster.cgi';
    frm.submit();

    return;
}
</script>
</head>

<body>
<h1></h1>

<form name="frm_list_domclust" method="post" action="">
<input type="hidden" name="type"       value="">
<input type="hidden" name="proj_id"    value="">
<input type="hidden" name="clusttabid" value="">
<input type="hidden" name="name"       value="">
EOB

    #
    print "<table border>\n";
    print "<tr><th></th>";
    foreach my$key (@key_list) {
        print "<th>$key</th>";
    }
    print "</tr>";

    while (my$ref=$sth->fetchrow_hashref()) {
        my(@dat) = ();
        foreach my$k (@key_list) {
            my($v) = $ref->{"$k"};
            if ($k eq 'cmd') {
                my($opt_sel) = {};
                my($opt_dom) = {};
                my(@spec_list) = RECOG::RecogCommon::rebuild_domclust_options($db, $ref->{'clusttabid'}, $opt_sel, $opt_dom);
                $v = '';
                if (scalar(@spec_list) != 0) {
                    $v = 'species=' . join(',', @spec_list);

                    #
                    my(%spec_hash);
                    foreach my$spec (@spec_list) {
                        $spec_hash{"$spec"} = 1;
                    }
                    foreach my$spec (split(/\,/, $opt_dom->{'-Ooutgroup'})) {
                        delete($spec_hash{"$spec"});
                    }
                    my(@spec_ingroup) = keys(%spec_hash);
                    $v .= '&ingroup=' . join(',', @spec_ingroup);

                }
                my($v_sel) = sprint_select_opt($opt_sel);
                if ($v_sel) {
                    $v .= '&' if ($v);
                    $v .= $v_sel;
                }
                my($v_dom) = sprint_domclust_opt($opt_dom);
                if ($v_dom) {
                    $v .= '&' if ($v);
                    $v .= $v_dom;
                }
            }
#            $v =~ s#([^a-z0-9])#sprintf("%%%02x", ord($1))#gei;
            push(@dat, $v);
        }

        #
        my($proj_id)     = $ref->{'proj_id'};
        my($clusttab_id) = $ref->{'clusttabid'};
        my($name)        = $ref->{'name'};
        print "<tr>";
        print qq{<td><input type="button" name="btn_del" value="DEL" onclick="delete_domclust($proj_id, '$clusttab_id', '$name');"></td>};
        foreach my$d (@dat) {
            print "<td>$d</td>";
        }
        print "</tr>\n";
    }
    print "</table>";
    print "</form>";
    print "</body>";

    return;
}

###############################################################################
#
sub list_project_phylopat {
    my($db) = shift;
    my($proj_id) = shift;
    my(@key_list) = ( 'proj_id', 'clusttabid', 'phylopatid',
                      'name', 'descr',
                      'cmd',
                      'cdate');

    #
    my(@args);
    my($cols)  = "p.proj_id, p.clusttabid, p.phylopatid, p.name as name, p.descr as descr, i.cmd as cmd, i.cdate as cdate";
    my($tab)   = "project_phylopat p left join cluster_tables_idx_phylopat i on p.phylopatid=i.clust_tab_id";
    my($where) = "1";
    if ($proj_id) {
        $where .= " and proj_id=?";
        push(@args, $proj_id);
    }
    my($order) = "proj_id, clusttabid, phylopatid";
    my($sql)   = "select $cols from $tab where $where order by $order";

    my($sth) = $db->prepare($sql);
    $sth->execute(@args);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOB;
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script>
function delete_phylopat(proj_id, clusttab_id, phylopat_id, name) {
    var doc = this.document;
    var frm = doc.frm_list_phylopat;

    var sta = confirm('Delete this result?');
    if (!sta) {
        return;
    }

    frm.type.value       = 'phylopat';
    frm.proj_id.value    = proj_id;
    frm.clusttabid.value = clusttab_id;
    frm.phylopatid.value = phylopat_id;
    frm.name.value       = name;

    //
    frm.target = 'win_' + proj_id + '_' + clusttab_id + '_' + phylopat_id;
    frm.action = '/htbin/recog_project/delete_project_cluster.cgi';
    frm.submit();

    return;
}
</script>
</head>

<body>
<h1></h1>

<form name="frm_list_phylopat" method="post" action="">
<input type="hidden" name="type"       value="">
<input type="hidden" name="proj_id"    value="">
<input type="hidden" name="clusttabid" value="">
<input type="hidden" name="phylopatid" value="">
<input type="hidden" name="name"       value="">
EOB

    #
    print "<table border>\n";
    print "<tr><th></th>";
    foreach my$key (@key_list) {
        print "<th>$key</th>";
    }
    print "</tr>";

    #
    while (my$ref=$sth->fetchrow_hashref()) {
        my(@dat) = ();
        foreach my$k (@key_list) {
            my($v) = $ref->{"$k"};
#            $v =~ s#([^a-z0-9])#sprintf("%%%02x", ord($1))#gei;
            push(@dat, $v);
        }

        #
        my($proj_id)     = $ref->{'proj_id'};
        my($clusttab_id) = $ref->{'clusttabid'};
        my($phylopat_id) = $ref->{'phylopatid'};
        my($name)        = $ref->{'name'};
        print "<tr>";
        print qq{<td><input type="button" name="btn_del" value="DEL" onclick="delete_phylopat($proj_id, '$clusttab_id', '$phylopat_id', '$name');"></td>};
        foreach my$d (@dat) {
            print "<td>$d</td>";
        }
        print "</tr>\n";
    }
    print "</table>";
    print "</form>";
    print "</body>";

    return;
}

###############################################################################
#
sub list_project_core {
    my($db) = shift;
    my($proj_id) = shift;
    my(@key_list) = ( 'proj_id', 'clusttabid', 'coreid',
                      'name', 'descr',
                      'cmd',
                      'cdate');

    #
    my(@args);
    my($cols)  = "p.proj_id, p.clusttabid, p.coreid, p.name as name, p.descr as descr, i.cmd as cmd, i.cdate as cdate";
    my($tab)   = "project_core p left join core_tables_idx i on p.coreid=i.core_tab_id";
    my($where) = "1";
    if ($proj_id) {
        $where .= " and proj_id=?";
        push(@args, $proj_id);
    }
    my($order) = "proj_id, clusttabid, coreid";
    my($sql)   = "select $cols from $tab where $where order by $order";

    my($sth) = $db->prepare($sql);
    $sth->execute(@args);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOB;
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script>
function delete_core(proj_id, clusttab_id, core_id, name) {
    var doc = this.document;
    var frm = doc.frm_list_phylopat;

    var sta = confirm('Delete this result?');
    if (!sta) {
        return;
    }

    frm.type.value       = 'core';
    frm.proj_id.value    = proj_id;
    frm.clusttabid.value = clusttab_id;
    frm.coreid.value     = core_id;
    frm.name.value       = name;

    //
    frm.target = 'win_' + proj_id + '_' + clusttab_id + '_' + core_id;
    frm.action = '/htbin/recog_project/delete_project_cluster.cgi';
    frm.submit();

    return;
}
</script>
</head>

<body>
<h1></h1>

<form name="frm_list_phylopat" method="post" action="">
<input type="hidden" name="type"       value="">
<input type="hidden" name="proj_id"    value="">
<input type="hidden" name="clusttabid" value="">
<input type="hidden" name="coreid"     value="">
<input type="hidden" name="name"       value="">
EOB

    #
print "<table border>\n";
    print "<tr><th></th>";
    foreach my$key (@key_list) {
        print "<th>$key</th>";
    }
    print "</tr>";

    #
    while (my$ref=$sth->fetchrow_hashref()) {
        my(@dat) = ();
        foreach my$k (@key_list) {
            my($v) = $ref->{"$k"};
#            $v =~ s#([^a-z0-9])#sprintf("%%%02x", ord($1))#gei;
            push(@dat, $v);
        }

        #
        my($proj_id)     = $ref->{'proj_id'};
        my($clusttab_id) = $ref->{'clusttabid'};
        my($core_id)     = $ref->{'coreid'};
        my($name)        = $ref->{'name'};
        print "<tr>";
        print qq{<td><input type="button" name="btn_del" value="DEL" onclick="delete_core($proj_id, '$clusttab_id', '$core_id', '$name');"></td>};
        foreach my$d (@dat) {
            print "<td>$d</td>";
        }
        print "</tr>\n";
    }
    print "</table>";
    print "</form>";
    print "</body>";

    return;
}

###############################################################################
#
sub list_project_cluster_win {
    my($form_opt) = shift;
    my($user_name) = $ENV{'REMOTE_USER'};

    #
    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    #
    my($uid) = RecogProjectCommon::exists_user_name($user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        # print no data
        return;
    }

    #
    my($type) = $form_opt->{'type'};
    my($proj_id) = $form_opt->{'proj_id'};

    #
    if ($type =~ /^phylopat$/i) {
        list_project_phylopat($db, $proj_id);
    }
    elsif ($type =~ /^core$/i) {
        list_project_core($db, $proj_id);
    }
    else { # default = 'domclust'
        list_project_domclust($db, $proj_id);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('proj_id', 'type');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    list_project_cluster_win($form_opt);
}

###############################################################################
1;#
###############################################################################
