#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use RecogProjectCommon;
use RECOG::DomClustCommon;
$main::DEBUG = 1;

###############################################################################
#
sub get_cluster_list_local {
    my($base_cluster_server) = shift;
    my($project_id) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    #
    my(%clust_name_hash);
    my($tab) = 'project_domclust';
    if ($db->exist_table($tab)) {
        my($sql) = "select * from $tab";
        if (0 < $project_id) {
            $sql .= " where proj_id=$project_id";
        }
        my($sth) = $db->execute($sql);
        while(my$ref = $sth->fetchrow_hashref()) {
            my($clust_id) = $ref->{'clusttabid'};
            $clust_name_hash{"$clust_id"} = $ref;
        }
    }

    #
    my(@cluster_list);
    my($tab) = 'cluster_tables_idx';
    if (!$db->exist_table($tab)) {
        return @cluster_list;
    }

    #
    my(%clust_sp_opt);
    my($sql) = "select * from $tab order by cdate";
    my($sth) = $db->execute($sql);
    while(my$ref = $sth->fetchrow_hashref()) {
        if (0 == $ref->{'status'}) {
            next; # ERROR
        }
        elsif (0 < $ref->{'status'}) {
            next; # Running
        }

        #
        my($clust_id) = $ref->{'clusterID'};
        my($file_o11) = "$ENV{'RECOG_HOME'}/MBGD.tmp/tmp_dom_res_$clust_id.o11";
        if (! -e "$file_o11") {
#            next;
        }

        #
        my($clust_ymd, $clust_hms) = split(/\s/, $ref->{'cdate'});
        my($clust_date) = $clust_ymd . ' ' . $clust_hms;
        my($n_clusters) = $ref->{'ncluster'};

        #
        my($cmd) = $ref->{'cmd'};

        my(%opt_clust1) = ($cmd =~ /(\-[^\s\=]+)\=(\S+)/gi);
        my($opt_clust1) = '';
        foreach my$k (sort keys(%opt_clust1)) {
            my($v) = $opt_clust1{"$k"};
            $opt_clust1 .= "$k=$v ";
        }
        my(%opt_clust2) = ($cmd =~ /(\-[A-Z]+)([\d\.]+)/gi);
        my($opt_clust2) = '';
        foreach my$k (sort keys(%opt_clust2)) {
            next if ($k =~ /\-tabout/);

            my($v) = $opt_clust2{"$k"};
            $opt_clust2 .= "$k$v ";
        }
        my($options) = $opt_clust1 . $opt_clust2;
        $options =~ s#\-SPEC\=(\S+)\s*##;
        my($species) = $1;
        $species =~ s#\'##g;

        #
        my($options4dump) = $options;
        $options4dump =~ s#\s+\-Ooutgroup\S+##;
        $options4dump =~ s#\s+\-Ohorizweight\S+##;
        $options4dump =~ s#\s+\-OtaxMap\S+##;
        $options4dump =~ s#\s+\-Ometa\S+##;

        #
        my($ref) = {};
        $ref->{'CLUSTER_ID'} = $clust_id;
        $ref->{'DATE'}       = $clust_date;
        $ref->{'OPTIONS'}    = $options4dump;
        $ref->{'SPECIES'}    = $species;
        if (exists($clust_name_hash{"$clust_id"})) {
            $ref->{'NAME'}   = $clust_name_hash{"$clust_id"}->{'name'};
        }

        if (!exists($clust_sp_opt{"$options4dump,$species"})) {
            push(@cluster_list, $ref);
        }
        $clust_sp_opt{"$options4dump,$species"} = 1;
    }

    return @cluster_list;
}

###############################################################################
#
sub mng_base_cluster_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($proj_ref) = $auth->load_project($user, $project_id);

    #
    my(@cluster_list);
    @cluster_list = get_cluster_list_local('', $project_id);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOS;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
<script>
function upd_cluster_name(cluster_id) {
    var doc = this.document;
    var frm = doc.frm_upd_base_cluster;

    frm.action = '/htbin/recog_project/upd_base_cluster_win.cgi';
    frm.target = 'win_upd_base_cluster';
    frm.cluster_id.value = cluster_id;
    frm.submit();

    return;
}

</script>
EOS
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Select base cluster</h1>\n";

    print <<EOB;
<form name="frm_upd_base_cluster" method="post">
EOB

    #
    if (scalar(@cluster_list) == 0) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    print <<EOB;
<input type="button" name="btn_close" value="Close" onclick="self.close();">
<input type="hidden" name="cluster_id" value="">

<table border>
<tr><th></th>
    <th>Cluster</th>
    <th>Date</th>
    <th>Options</th>
    <th>Species</th>
</tr>

EOB

    #
    foreach my$cluster_ref (@cluster_list) {
        next if (!$cluster_ref->{'CLUSTER_ID'});

        my($cluster_id) = $cluster_ref->{'CLUSTER_ID'};
        print qq{<tr>};
        print <<EOB;
<td><input type="button" name="btn_name" value="Edit" onclick="upd_cluster_name('$cluster_id');">
</td>
EOB

        my($cluster_name) = $cluster_ref->{'CLUSTER_ID'};
        if ($cluster_ref->{'CLUSTER_NAME'} ne '') {
            $cluster_name = $cluster_ref->{'CLUSTER_NAME'}
                          . '('
                          . $cluster_ref->{'CLUSTER_ID'}
                          . ')';
        }
        print qq{<td style="">$cluster_name</td>};
        print qq{<td style="white-space: nowrap;">$cluster_ref->{'DATE'}</td>};
        print qq{<td>$cluster_ref->{'OPTIONS'}</td>};
        print qq{<td>$cluster_ref->{'SPECIES'}</td>};
        print qq{</tr>\n};
    }

    print <<EOB;
</table>
<input type="hidden" name="project_id" value="$project_id">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my(@key_list) = ( 'project_id',
                      'base_cluster_server',
                    );
    my($form_opt) = {};
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }
    mng_base_cluster_win($form_opt);
}
###############################################################################
1;#
###############################################################################
