#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'libMBGDaxes.pl';

###############################################################################
sub mod_project_user {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($proj_id)   = $form_opt->{'project_id'};
    my($user_name) = $form_opt->{'user_name'};

    my($auth) = RECOG::RecogProject->new();

    #
    my($sta) = $auth->exists_project($user, $proj_id);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($sta) = $auth->permit_project_user($user,
                                          $proj_id,
                                          $RECOG::RecogProject::ACT_ADD_USR);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my(@role_list) = @RECOG::RecogProject::AUTH_PRJ;
    if ($auth->is_system_project($user, $proj_id)) {
        @role_list = @RECOG::RecogProject::AUTH_SYS;
    }
    else {
        my($role) = $RECOG::RecogProject::AUTH_PRJ_admin;
        my($role_admin) = $form_opt->{"$role"};
        if ($role_admin !~ /^yes$/i) {
            my($sta) = $auth->exists_project_admin($user, $proj_id, $user_name);
            if (!$sta) {
                my($msg) = "Project needs 1 or more 'admin' user.";
                $auth->print_html_sorry($user, $msg);
                exit();
            }
        }
    }

    #
    my(@user_role_list);
    foreach my$role (@role_list) {
        my($sta) = $form_opt->{"$role"};
        if ($sta =~ /^yes$/i) {
            push(@user_role_list, $role);
        }
    }
    $auth->clear_role_project_user($user, $proj_id, $user_name);
    $auth->set_role_project_user($user, $proj_id, $user_name, @user_role_list);
    $auth->save_project($user, $proj_id);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Modify project member</h1>\n";
    print "<form>\n";

    print <<EOB;
Done.<br>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id', 'user_name',
                     @RECOG::RecogProject::AUTH_PRJ,
                     @RECOG::RecogProject::AUTH_SYS);
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    mod_project_user($form_opt);
}

###############################################################################
1;#
###############################################################################
