#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
sub passwd {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    my($user_email) = $form_opt->{'user_email'};

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    my($sta_auth_sys_admin) = RecogProjectCommon::auth_user_proj($RecogProjectCommon::AUTH_SYS_ADMIN, $user);
    if ((!$sta_auth_sys_admin) && ($user ne $user_email)) {
        #
        print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
</head>
<body>
<h1>Sorry, can not change password for $user_email.</h1>
</body>
</html>
EOB
        return;
    }

    #
    my($user_pass1) = $form_opt->{'user_pass1'};
    my($user_pass2) = $form_opt->{'user_pass2'};
    if ($user_pass1 ne $user_pass2) {
        print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
</head>
<body>
<h1>Not same password. [$user_email]</h1>
</body>
</html>
EOB
        return;
    }
    elsif ($user_pass1 =~ /^\s*$/) {
        print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
</head>
<body>
<h1>Blank password. [$user_email]</h1>
</body>
</html>
EOB
        return;
    }

    RecogProjectCommon::passwd_user($user_email, $user_pass1);

    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
<script>
    this.top.opener.location.reload();
</script>
</head>
<body>
<h1>Success.</h1>
<form>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('user_email',
                     'user_pass1',
                     'user_pass2',
                     'user_organization',
                    );
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }
    passwd($form_opt);
}

###############################################################################
1;#
###############################################################################
