#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub put_project_domclust {
    my($db) = shift;
    my($uid) = shift;
    my($proj_id) = shift;
    my($clusttabid) = shift;
    my($name) = shift;
    my($descr) = shift;
    my($view_opts) = shift;
    my($opt) = shift;

    if (!$proj_id || !$clusttabid || !$name) {
        my($sta) = 'error';
        my($msg) = 'Missing some parameter(s).';
        RecogProjectCommon::print_status($sta, $msg);
        exit(0);
    }
    $proj_id = RecogProjectCommon::conv_proj_id($proj_id);

    my($tab) = "project_domclust";
    my($where) = "proj_id=? and clusttabid=? and name=?";
    my($sql) = "select * from $tab where $where";

    my($sth) = $db->prepare($sql);
    $sth->execute($proj_id, $clusttabid, $name);
    if ($sth->rows() != 0) {
        if ($opt->{'mode'} =~ /^replace$/i) {
            my($sql) = "update $tab set descr=?, view_opts=? where $where";
            my($sth) = $db->prepare($sql);
            $sth->execute($descr, $view_opts, $proj_id, $clusttabid, $name);
        }
        else {
            my($sta) = 'error';
            my($msg) = 'already exists.';
            RecogProjectCommon::print_status($sta, $msg);
            exit(0);
        }
    }
    else {
        my($sql) = "insert $tab (proj_id, clusttabid, name, descr, view_opts) values(?, ?, ?, ?, ?)";
        my($sth) = $db->prepare($sql);
        $sth->execute($proj_id, $clusttabid, $name, $descr, $view_opts);
    }

    return;
}

###############################################################################
#
sub put_project_phylopat {
    my($db) = shift;
    my($uid) = shift;
    my($proj_id) = shift;
    my($clusttabid) = shift;
    my($phylopatid) = shift;
    my($name) = shift;
    my($descr) = shift;
    my($opt) = shift;

    if (!$proj_id || !$clusttabid || !$phylopatid || !$name) {
        my($sta) = 'error';
        my($msg) = 'Missing some parameter(s).';
        RecogProjectCommon::print_status($sta, $msg);
        exit(0);
    }
    $proj_id = RecogProjectCommon::conv_proj_id($proj_id);

    my($tab) = "project_phylopat";
    my($where) = "proj_id=? and clusttabid=? and phylopatid=? and name=?";
    my($sql) = "select * from $tab where $where";

    my($sth) = $db->prepare($sql);
    $sth->execute($proj_id, $clusttabid, $phylopatid, $name);
    if ($sth->rows() != 0) {
        if ($opt->{'mode'} =~ /^replace$/i) {
            my($sql) = "update $tab set descr=? where $where";
            my($sth) = $db->prepare($sql);
            $sth->execute($descr, $proj_id, $clusttabid, $phylopatid, $name);
        }
        else {
            my($sta) = 'error';
            my($msg) = 'already exists.';
            RecogProjectCommon::print_status($sta, $msg);
            exit(0);
        }
    }
    else {
        my($sql) = "insert $tab (proj_id, clusttabid, phylopatid, name, descr) values(?, ?, ?, ?, ?)";
            my($sth) = $db->prepare($sql);
            $sth->execute($proj_id, $clusttabid, $phylopatid, $name, $descr);
    }

    return;
}

###############################################################################
#
sub put_project_core {
    my($db) = shift;
    my($uid) = shift;
    my($proj_id) = shift;
    my($clusttabid) = shift;
    my($coreid) = shift;
    my($name) = shift;
    my($descr) = shift;
    my($opt) = shift;

    if (!$proj_id || !$clusttabid || !$coreid || !$name) {
        my($sta) = 'error';
        my($msg) = 'Missing some parameter(s).';
        RecogProjectCommon::print_status($sta, $msg);
        exit(0);
    }
    $proj_id = RecogProjectCommon::conv_proj_id($proj_id);

    my($tab) = "project_core";
    my($where) = "proj_id=? and clusttabid=? and coreid=? and name=?";
    my($sql) = "select * from $tab where $where";

    my($sth) = $db->prepare($sql);
    $sth->execute($proj_id, $clusttabid, $coreid, $name);
    if ($sth->rows() != 0) {
        if ($opt->{'mode'} =~ /^replace$/i) {
            my($sql) = "update $tab set descr=? where $where";
            my($sth) = $db->prepare($sql);
            $sth->execute($descr, $proj_id, $clusttabid, $coreid, $name);
        }
        else {
            my($sta) = 'error';
            my($msg) = 'already exists.';
            RecogProjectCommon::print_status($sta, $msg);
            exit(0);
        }
    }
    else {
        my($sql) = "insert $tab (proj_id, clusttabid, coreid, name, descr) values(?, ?, ?, ?, ?)";
            my($sth) = $db->prepare($sql);
            $sth->execute($proj_id, $clusttabid, $coreid, $name, $descr);
    }

    return;
}

###############################################################################
#
sub put_project_cluster {
    my($form_opt) = shift;
    my($user_name) = $ENV{'REMOTE_USER'};

    #
    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    #
    my($uid) = RecogProjectCommon::exists_user_name($user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($type)       = $form_opt->{'type'};
    my($proj_id)    = $form_opt->{'proj_id'};
    my($clusttabid) = $form_opt->{'clusttabid'};
    my($phylopatid) = $form_opt->{'phylopatid'};
    my($coreid)     = $form_opt->{'coreid'};
    my($name)       = $form_opt->{'name'};
    my($descr)      = $form_opt->{'descr'};
    my($view_opts)  = $form_opt->{'view_opts'};

    #
    if ($type =~ /^domclust$/i) {
        put_project_domclust($db, $uid, $proj_id, $clusttabid, $name, $descr, $view_opts, $form_opt);
    }
    elsif ($type =~ /^phylopat$/i) {
        put_project_phylopat($db, $uid, $proj_id, $clusttabid, $phylopatid, $name, $descr, $form_opt);
    }
    elsif ($type =~ /^core$/i) {
        put_project_core($db, $uid, $proj_id, $clusttabid, $coreid, $name, $descr, $form_opt);
    }
    else {
    }

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('type', 'proj_id', 'clusttabid', 'phylopatid', 'coreid',
                     'name', 'descr', 'view_opts',
                     'mode');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $val =~ s#^\s*##;
        $val =~ s#\s*$##;
        $form_opt->{"$key"} = $val;
print STDERR "$key, $val\n";
    }

    put_project_cluster($form_opt);
}

###############################################################################
1;#
###############################################################################
