#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
sub print_user {
    my($user_ref) = shift;

    print qq{<a href="/htbin/recog_project/view_user.cgi?user_id=$user_ref->{'id'}">$user_ref->{'name'}</a>\n};

    return;
}

###############################################################################
sub print_project_html {
    my($db) = shift;
    my($proj_ref) = shift;

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print "<h1>View Project</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    print <<EOB;
<table border>
<tr><th>Name</th>
    <td>$proj_ref->{'NAME'}
    </td>
</tr>

<tr><th>Descr</th>
    <td><pre>$proj_ref->{'DESCR'}</pre></td>
</tr>
EOB

    my($user_list_ref) = RecogProjectCommon::get_user_list_by_project($db, $proj_ref->{'NAME'}, my$sta_user=1);
    print "<tr><th>Member</th>\n";
    print "    <td>";
    foreach my$ref (@{$user_list_ref}) {
        print_user($ref);
    }
    print "    </td>\n";

    my($user_list_ref) = RecogProjectCommon::get_user_list_by_project($db, $proj_ref->{'id'}, my$sta_user=0);
    print "<tr><th>Waiting</th>\n";
    print "    <td>";
    foreach my$ref (@{$user_list_ref}) {
        print_user($ref);
    }
    print "    </td>\n";

    print <<EOB;
</table>
</body>
</html>
EOB

    return;
}

###############################################################################
sub print_project_text {
    my($db) = shift;
    my($proj_ref) = shift;

    #
    print "Content-type: text/plain\n";
    print "\n";

    #
    print '#', join("\t", 'Name', 'Descr', 'spid'), "\n";

    #
    my($name) = $proj_ref->{'NAME'};
    $name =~ s#(\W)#sprintf("%%%02X", ord($1))#ge;

    #
    my($descr) = $proj_ref->{'DESCR'};
    $descr =~ s#(\W)#sprintf("%%%02X", ord($1))#ge;

    #
    my($spid_list) = join(',', @{$proj_ref->{'SPID_LIST'}});
    print join("\t", $name,
                     $descr,
                     $spid_list), "\n";

    return;
}

###############################################################################
sub view_project_win {
    my($form_opt) = shift;

    #
    my($user) = $ENV{'REMOTE_USER'};
    my($mode) = $form_opt->{'mode'};
    my($project_name) = $form_opt->{'project_name'};

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($db) = MBGD::DB->new($dbname);
    my($proj_ref) = RecogProjectCommon::get_project($project_name);

    if ($mode !~ /^text/i) {
        print_project_html($db, $proj_ref);
    }
    else {
        print_project_text($db, $proj_ref);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('mode', 'project_name') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    view_project_win($form_opt);
}

###############################################################################
1;#
###############################################################################
