/*@cc_on _d=document;eval('var document=_d')@*/
///////////////////////////////////////////////////////////////////////////////
function change_gold_field(field_val) {
    var doc = document;
    var form = doc.getElementById('form_select_organism');

    var n = form.gold_field.options.length;
    var opts = form.gold_field.options;
    for(var i = 0; i < n; i++) {
        var elm_field = opts[i];
        var val = elm_field.value;
        var elm_lnk = doc.getElementById('gold_lnk_' + val);
        var elm_spn = doc.getElementById('gold_spn_' + val);
        var elm_sel = doc.getElementById('gold_sel_' + val);
        if (elm_field.value == field_val) {
            elm_lnk.style.backgroundColor = '#d8f0d8';
            elm_spn.style.display = 'inline';
        }
        else {
            elm_lnk.style.backgroundColor = '#b0d2b0';
            elm_spn.style.display = 'none';
        }
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function disp_speclist_selected(form, sp_selected, upd_taxtree) {
    var idx = 0;

    //
    form.species_list.options.length = 0;

    var n = form.species_all.options.length;
    var opts_all = form.species_all.options;
    var opts_lst = form.species_list.options;
    for(var i = 0; i < n; i++) {
        var sp = opts_all[i].value;
        if (sp_selected[sp] != 1) {
            if (upd_taxtree) {
                hide_taxtree_species(sp);
            }
            continue;
        }

        opts_lst[idx] = new Option(opts_all[i].text, opts_all[i].value);
//        opts_lst[idx].selected = true; //opts_all[i].selected;
        if (upd_taxtree) {
            show_taxtree_species(sp);
        }
        idx++;
    }

    if (upd_taxtree) {
        change_spec_list();
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function disp_spectree_selected(form, sp_selected) {
    //
    var n = form.species_all.options.length;
    var opts = form.species_all.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value;
        if (sp_selected[sp] != 1) {
            hide_taxtree_species(sp);
        }
        else {
            show_taxtree_species(sp);
        }
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function disp_spec_all(form) {
    //
    form.species_list.options.length = 0;

    var n = form.species_all.options.length;
    var opts_all = form.species_all.options;
    var opts_lst = form.species_list.options;
    for(var i = 0; i < n; i++) {
        opts_lst[i] = new Option(opts_all[i].text,
                                 opts_all[i].value);
        opts_lst[i].selected = opts_all[i].selected;
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function hide_spec_all(form) {

    form.species_list.options.length = 0;

    return;
}

///////////////////////////////////////////////////////////////////////////////
function ctrl_list_spec(form, elm_sel, sp_selected) {

    var this_sp_selected = new Object();
    var n = elm_sel.options.length;
    var opts = elm_sel.options;
    for(var i = 0; i < n; i++) {
        var e = opts[i];
        if (e.selected) {
            var sp_list = e.value.split(',');
            var nn = sp_list.length;
            for(var j = 0; j < nn; j++) {
                var sp = sp_list[j];
                this_sp_selected[sp] = 1;
            }
        }
    }

    //
    var n = form.species_all.options.length;
    var opts = form.species_all.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value;
        if ((sp_selected[sp] == 1) && (this_sp_selected[sp] == 1)) {
            sp_selected[sp] = 1;
        }
        else {
            sp_selected[sp] = 0;
        }
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function update_list_spec(form) {
    var doc = document;
    var sta_select = 0;

    var sp_selected = new Object();
    var n = form.species_all.options.length;
    var opts = form.species_all.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value;
        sp_selected[sp] = 1;
    }

    var n = form.gold_field.options.length;
    var opts = form.gold_field.options;
    for(var i = 0; i < n; i++) {
        var val = opts[i].value;
        var key = 'gold_sel_' + val;
        var elm_lnk = doc.getElementById('gold_lnk_' + val);
        var elm_sel = doc.getElementById('gold_sel_' + val);
        var n_selected = elm_sel.selectedIndex;
        if (0 <= n_selected) {
            sta_select++;
            ctrl_list_spec(form, elm_sel, sp_selected);

            elm_lnk.style.fontWeight  = 'bold';
            elm_lnk.innerText   = '=' + val + '=';
            elm_lnk.textContent = '=' + val + '=';
        }
        else {
            elm_lnk.style.fontWeight = 'normal';
            elm_lnk.innerText   = val;
            elm_lnk.textContent = val;
        }
    }

    //
    if (sta_select == 0) {
        disp_spec_all(form);
        show_taxtree_all();
        return;
    }

    hide_spec_all(form);
    disp_speclist_selected(form, sp_selected);

    //
    var n = form.species_list.options.length;
    var opts = form.species_list.options;
    for(var i = 0; i < n; i++) {
        opts[i].selected = true;;
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function update_tree_spec(form) {
    var doc = document;
    var sta_select = 0;

    var sp_selected = new Object();
    var n = form.species_all.options.length;
    var opts = form.species_all.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value;
        sp_selected[sp] = 1;
    }

    var n = form.gold_field.options.length;
    var opts = form.gold_field.options;
    for(var i = 0; i < n; i++) {
        var val = opts[i].value;
        var elm_lnk = doc.getElementById('gold_lnk_' + val);
        var elm_sel = doc.getElementById('gold_sel_' + val);
        if (0 <= elm_sel.selectedIndex) {
            sta_select++;
            ctrl_list_spec(form, elm_sel, sp_selected);

            elm_lnk.style.fontWeight  = 'bold';
            elm_lnk.innerText   = '=' + val + '=';
            elm_lnk.textContent = '=' + val + '=';
        }
        else {
            elm_lnk.style.fontWeight = 'normal';
            elm_lnk.innerText   = val;
            elm_lnk.textContent = val;
        }
    }

    //
    if (sta_select == 0) {
        show_taxtree_all();
        return;
    }

    disp_spectree_selected(form, sp_selected);

    return;
}

///////////////////////////////////////////////////////////////////////////////
function clear_gold_field(f) {
    var doc = document;

    //
    var key = 'gold_sel_' + f;
    var elm_field = doc.getElementById(key);
    var n = elm_field.options.length;
    var opts = elm_field.options;
    for (var i = 0; i < n; i++) {
        var elm = opts[i];
        elm.selected = false;
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function clear_gold_field_all() {
    var doc = document;

    //
    var key = 'gold_sel_field';
    var elm_field_list = doc.getElementById(key);
    var n = elm_field_list.options.length;
    var opts = elm_field_list.options;
    for (var i = 0; i < n; i++) {
        var elm = opts[i];
        clear_gold_field(elm.value);
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function disp_organism_selection(form, type) {
    var doc = document;
    var key;
    var elm;

    //
    var gold_display     = 'block';
    var taxonomy_display = 'none';
    if (type == 'taxonomy') {
        gold_display     = 'none';
        taxonomy_display = 'block';

        var agent = get_agent();
//        if ((agent['name'] == 'msie') && (agent['ver'] < 8)) {
        if (agent['name'] == 'msie') {
            // too slow
//            alert('SKIP :: update_tree_spec()');
            update_tree_spec(form);
        }
        else {
            update_tree_spec(form);
        }
    }

    //
    key = 'organism_selection_gold';
    elm = doc.getElementById(key);
    elm.style.display = gold_display;

    //
    key = 'organism_selection_taxonomy';
    elm = doc.getElementById(key);
    elm.style.display = taxonomy_display;

    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function hide_taxtree_parent(pnode) {
    if (! pnode) {
        return;
    }
    if (pnode.id == 'organism_selection_taxonomy') {
        return;
    }
    if (pnode.style.display == 'none') {
        return;
    }

//    for (var elm in pnode.childNodes) {
    var n = pnode.childNodes.length;
    var cn = pnode.childNodes;
    for (var i = 0; i < n; i++) {
        var elm = cn[i];
        var tag_name = elm.tagName;
        if ((tag_name != 'LI') && (tag_name != 'UL') && (tag_name != 'SPAN')) {
            continue;
        }

        if (elm.style.display != 'none') {
            return;
        }
    }

    pnode.style.display = 'none';

    hide_taxtree_parent(pnode.parentNode);

    return;
}

///////////////////////////////////////////////////////////////////////////////
function hide_taxtree_species(sp) {
    var doc = document;
    var key;
    var elm;

    //
    key = 'species_chkbox_' + sp;
    elm = doc.getElementById(key);
    elm.disabled = true;

    key = 'species_' + sp;
    elm = doc.getElementById(key);
    elm.style.display = 'none';

    hide_taxtree_parent(elm.parentNode);
//    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function show_taxtree_parent(pnode) {
    if (! pnode) {
        return;
    }
    if (pnode.id == 'organism_selection_taxonomy') {
        return;
    }

    if (pnode.style.display == 'none') {
        pnode.style.display = '';
        show_taxtree_parent(pnode.parentNode);
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function show_taxtree_species(sp) {
    var doc = document;
    var key;
    var elm;

    //
    key = 'species_chkbox_' + sp;
    elm = doc.getElementById(key);
    elm.disabled = false;

    key = 'species_' + sp;
    elm = doc.getElementById(key);
    elm.style.display = 'block';

    show_taxtree_parent(elm.parentNode);

//    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function show_taxtree_children(pnode) {
    var doc = document;

    var n = pnode.childNodes.length;
    var cn = pnode.childNodes;
    for (var i = 0; i < n; i++) {
        var elm = cn[i];
//        if ((elm.tagName != 'LI') && (elm.tagName != 'UL') && (elm.tagName != 'SPAN')) {
//            continue;
//        }

        var estyle = elm.style;
        if (estyle) {
            if (estyle.display == 'none') {
                estyle.display = 'block';
            }
        }
        if (elm.name == 'species') {
            elm.disabled = false;
        }
        show_taxtree_children(elm);
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function show_taxtree_all() {
    var doc = document;
    var key;
    var elm;

    key = 'organism_selection_taxonomy';
    elm = doc.getElementById(key);
    show_taxtree_children(elm);

    return;
}

///////////////////////////////////////////////////////////////////////////////
function select_all_species(sta) {
    var doc = document;
    var frm = doc.specForm;

    var opts = frm.species_list.options;
    var n = opts.length;
    for(var i = 0; i < n; i++) {
        opts[i].selected = sta;
    }

    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function change_spec_list() {
    var doc = document;
    var f = doc.specForm;

    if (! f.selected_species) {
        return;
    }

    //
    var n = f.species.length;
    var opts = f.species;
    for (var i = 0; i < n; i++) {
        opts[i].checked = false;
    }

    //
    var n = f.selected_species.options.length;
    var opts = f.selected_species.options;
    for(var i = 0; i < n; i++) {
        var elm_list = opts[i];
        var key = 'species_chkbox_' + elm_list.value;
        var elm_checkbox = doc.getElementById(key);
        elm_checkbox.checked = true;
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function sync_species(spec) {
    var doc = document;
    var frm = doc.specForm;

    var key = 'species_chkbox_' + spec;
    var elm = doc.getElementById(key);
    var sta = elm.checked;

    var opts = frm.species_list.options;
    var n = opts.length;
    for(i = 0; i < n; i++) {
        if (opts[i].value == spec) {
            opts[i].selected = sta;
            break;
        }
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function remove_all_species(src) {
    src.length = 0;

    return;
}

///////////////////////////////////////////////////////////////////////////////
function remove_selected_species(src) {
    var opts = src.options;
    for(var i = src.length - 1; 0 <= i; i--) {
        if (opts[i].selected) {
            opts[i] = null;
        }
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function add_selected_species(all, src, dst) {
    var doc = document;
    var add_species_hash = new Object();
    var selected_species_hash = new Object();

    //
    var n = src.length;
    var opts = src.options;
    for(var i = 0; i < n; i++) {
        var elm = opts[i];
        if (elm.selected) {
            var val = elm.value;
            add_species_hash[val] = 1;
        }
    }
    var n = dst.length;
    var opts = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts[i];
//        if (elm.selected) {
            var val = elm.value;
            selected_species_hash[val] = 1;
//        }
    }

    var ofs = 0;
    dst.options.length = 0;
    var n = all.length;
    var opts_all = all.options;
    var opts_dst = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts_all[i];
        var val = opts_all[i].value;
        if (add_species_hash[val] == 1) {
            opts_dst[ofs] = new Option(elm.text, elm.value);
            opts_dst[ofs].selected = true;
            ofs++;
        }
        else if (selected_species_hash[val] == 1) {
            opts_dst[ofs] = new Option(elm.text, elm.value);
            opts_dst[ofs].selected = false;
            ofs++;
        }
    }

    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function mod_selected_species(all, dst, spec_add, spec_del) {
    var doc = document;
    var selected_species_hash = new Object();

    var n = dst.length;
    var opts = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts[i];
//        if (elm.selected) {
            var val = elm.value;
            selected_species_hash[val] = 1;
//        }
    }

    var ofs = 0;
    dst.options.length = 0;
    var n = all.length;
    var opts_all = all.options;
    var opts_dst = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts_all[i];
        var val = opts_all[i].value;
        if (spec_add[val] == 1) {
            opts_dst[ofs] = new Option(elm.text, elm.value);
            opts_dst[ofs].selected = true;
            ofs++;
        }
        else if (spec_del[val] == 1) {
            continue;
        }
        else if (selected_species_hash[val] == 1) {
            opts_dst[ofs] = new Option(elm.text, elm.value);
            opts_dst[ofs].selected = false;
            ofs++;
        }
    }

    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function add_a_spec(spec) {
    var doc = document;
    var f = doc.specForm;
    var all = f.species_all;
    var dst = f.selected_species;

    var selected_species_hash = new Object();
    var n = dst.length;
    var opts = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts[i];
//        if (elm.selected) {
            var val = elm.value;
            selected_species_hash[val] = 1;
//        }
    }

    var ofs = 0;
    dst.options.length = 0;
    var n = all.length;
    var opts_all = all.options;
    var opts_dst = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts_all[i];
        var val = opts_all[i].value;
        if (val == spec) {
            opts_dst[ofs] = new Option(elm.text, elm.value);
            opts_dst[ofs].selected = true;
            ofs++;
        }
        else if (selected_species_hash[val] == 1) {
            opts_dst[ofs] = new Option(elm.text, elm.value);
            opts_dst[ofs].selected = false;
            ofs++;
        }
    }

    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function del_a_spec(spec) {
    var doc = document;
    var f = doc.specForm;
    var all = f.species_all;
    var dst = f.selected_species;

    var selected_species_hash = new Object();
    var n = dst.length;
    var opts = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts[i];
//        if (elm.selected) {
            var val = elm.value;
            selected_species_hash[val] = 1;
//        }
    }

    var ofs = 0;
    dst.options.length = 0;
    var n = all.length;
    var opts_all = all.options;
    var opts_dst = dst.options;
    for(var i = 0; i < n; i++) {
        var elm = opts_all[i];
        var val = opts_all[i].value;
        if (val == spec) {
            continue;
        }
        else if (selected_species_hash[val] == 1) {
            opts_dst[ofs] = new Option(elm.text, elm.value);
            opts_dst[ofs].selected = false;
            ofs++;
        }
    }

    change_spec_list();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function check_selected_organisms() {
    var doc = document;
    var frm = doc.specForm;

    var n = frm.selected_species.options.length;
    var opts = frm.selected_species.options;
    for(var i = 0; i < n; i++) {
        opts[i].selected = true;
    }

    frm.target = 'win_check_selected_organisms';
    frm.action = '/htbin/check_selected_organisms.cgi';
    frm.submit();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function check_occurrence_organisms(sel_all, sel1, sel2) {

    //
    var occurrence_sp1 = new Object();
    var n = sel1.options.length;
    var opts1 = sel1.options;
    for(var i = 0; i < n; i++) {
        var sp = opts1[i].value;
        occurrence_sp1[sp] = 1;
    }

    //
    var occurrence_sp2 = new Object();
    var n = sel2.options.length;
    var opts2 = sel2.options;
    for(var i = 0; i < n; i++) {
        var sp = opts2[i].value;
        occurrence_sp2[sp] = 1;
    }

    //
    var ofs = 0;
    sel2.options.length = 0;
    var n = sel_all.options.length;
    var opts_all = sel_all.options;
    for(var i = 0; i < n; i++) {
        var elm = opts_all[i];
        var sp = elm.value;
        if (occurrence_sp1[sp] == 1) {
            continue;
        }
        if (occurrence_sp2[sp] != 1) {
            continue;
        }

        sel2.options[ofs] = new Option(elm.text, elm.value);
        ofs++;
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function save_species_color() {
    var doc = document;

    var doc = this.document;
    var frm = doc.specForm;

    var n = frm.selected_species.options.length;
    var opts = frm.selected_species.options;
    for (var i = 0; i < n; i++) {
        var elm = opts[i];
        elm.selected = true;
    }

    //
    doc.specForm.action = '/htbin/save_spec_color.cgi';
    doc.specForm.submit();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function choose_color(elm) {

    var sel_idx = elm.selectedIndex;
    var color = elm.options[sel_idx].value;

    elm.style.backgroundColor = color;

    return;
}

///////////////////////////////////////////////////////////////////////////////
function set_species_color(src) {
    var doc = document;

    //
    var key = 'organism_color';
    var elm = doc.getElementById(key);
    var col = elm.value;

    //
    var n = src.length;
    var opts = src.options;
    for(var i = 0; i < n; i++) {
        var elm = opts[i];
        if (elm.selected) {
            var sp = elm.value;
            key = 'spec_color_' + sp;
            elm = doc.getElementById(key);
            elm.value = col;
        }
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function upd_species_color() {
    var doc = this.document;
    var frm = doc.specForm;

    var n = frm.selected_species.options.length;
    var opts = frm.selected_species.options;
    for (var i = 0; i < n; i++) {
        var elm = opts[i];
        var sp = elm.value;
        var key = 'spec_color_' + sp;
        var color = doc.getElementById(key);

        elm.selected = false;
        elm.style.backgroundColor = color.value;
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function upd_phylopat_image() {
    var doc = document;
    var form = doc.specForm;

    //
    var sp_presence = new Object();
    var n = form.presence_species.options.length;
    var opts = form.presence_species.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value
        sp_presence[sp] = 1;
    }

    //
    var sp_absence = new Object();
    var n = form.absence_species.options.length;
    var opts = form.absence_species.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value
        sp_absence[sp] = 1;
    }

    //
    var phylopat = '';
    var n = form.species_all.options.length;
    var opts = form.species_all.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value;
        if (sp_presence[sp] == 1) {
            phylopat += '1';
        }
        else if (sp_absence[sp] == 1) {
            phylopat += '2';
        }
        else {
            phylopat += '0';
        }
    }

    //
    var url = '/htbin/create_phylopat_gif'
            + '?' + form.phylopat_tabid.value
            + '&' + 'phylopat=' + phylopat
            + '&' + 'color=009900,ffff66';

    var key = 'img_phylopat';
    var elm = doc.getElementById(key);
    elm.src = url;

    return;
}

///////////////////////////////////////////////////////////////////////////////
function set_occurrence_pattern() {
    var pwin = window.opener
    var pdoc = pwin.document;
    var doc = document;
    var form = doc.specForm;

    //
    var n = form.species_all.options.length;
    var opts = form.species_all.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value
        var key = 'exist_' + sp;
        var elm = pdoc.getElementById(key);
        elm.value = 0;
    }

    //
    var n = form.presence_species.options.length;
    var opts = form.presence_species.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value
        var key = 'exist_' + sp;
        var elm = pdoc.getElementById(key);
        elm.value = 1;
    }

    //
    var n = form.absence_species.options.length;
    var opts = form.absence_species.options;
    for(var i = 0; i < n; i++) {
        var sp = opts[i].value
        var key = 'exist_' + sp;
        var elm = pdoc.getElementById(key);
        elm.value = -1;
    }

    pwin.upd_occurrence_pattern_image();

    close();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function select_organisms() {
    // frm.action = '/htbin/cluster';
    // frm.submit();

    return;
}

///////////////////////////////////////////////////////////////////////////////
function sync_spec_taxonomy(dir) {
    var doc = document;
    var frm = doc.specForm;

    var opts = frm.species_list.options;
    var n = opts.length;
    for(var i = 0; i < n; i++) {
        var spec = opts[i].value;
        var key = 'species_chkbox_' + spec;
        var elm = doc.getElementById(key);
        if (dir != true) {
            opts[i].selected = elm.checked;
        }
        else {
            elm.checked = opts[i].selected;
        }
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function post_selectall() {
    // 
    sync_spec_taxonomy(false);

    return;
}

///////////////////////////////////////////////////////////////////////////////
function open_close_tab(name_tab, arrow) {
    var doc = document;

    var ent = doc.getElementById(name_tab);
    var ent_style = ent.style;

    if (ent_style.display == 'none') {
        ent_style.display = 'inline';
        arrow.innerText =
        arrow.textContent = '[-]';
    }
    else {
        arrow.innerText =
        arrow.textContent = '[+]';
        ent_style.display = 'none';
    }

    return;
}

///////////////////////////////////////////////////////////////////////////////
function select_public_species(name_tab, arrow) {
    var doc = document;

    var doc = this.document;
    var frm = doc.specForm;

    var n = frm.selected_species.options.length;
    var opts = frm.selected_species.options;
    for (var i = 0; i < n; i++) {
        var elm = opts[i];
        elm.selected = true;
    }

    //
    doc.specForm.action = '/htbin/recog_build/organism_selection_recog_save.cgi';
    doc.specForm.submit();

    return;
}

///////////////////////////////////////////////////////////////////////////////
// eof
///////////////////////////////////////////////////////////////////////////////
