//
function clear_building_status_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0110clear_building_status.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function update_taxonomy() {
    var doc = this.document;
    var frm = doc.frm_update_taxonomy;

    // download
    frm.action = '/htbin/recog_build/update_taxonomy.cgi'; 
    frm.submit();

    return;
}

//
function update_public_species() {
    var doc = this.document;
    var frm = doc.frm_update_public_species;

    // download
    frm.action = '/htbin/recog_build/update_public_species.cgi'; 
    frm.submit();

    return;
}

//
function status_taxonomy(msg) {
    var http_req = get_http_req();
    var params = '';

    //
    var elm_body = document.getElementById('body');

    // download
    var uri = '/htbin/recog_build/status_taxonomy.cgi'; 
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var sta = http_req.responseText;
        elm_body.innerHTML = '<h1>' + msg + '</h1>' + '<h2>' + sta + '</h2>';
        if (sta == 'done') {
            return;
        }

        setTimeout("status_taxonomy('" + msg + "');", 5000);
    };

    return;
}

//
function update_cdd() {
    var doc = this.document;
    var frm = doc.frm_update_cdd;

    // download
    frm.action = '/htbin/recog_build/update_cdd.cgi'; 
    frm.submit();

    return;
}

//
function update_kegg_orgs() {
    var doc = this.document;
    var frm = doc.frm_update_kegg_orgs;

    // download
    frm.action = '/htbin/recog_build/update_kegg_orgs.cgi'; 
    frm.submit();

    return;
}

//
function update_ncbi_lproks() {
    var doc = this.document;
    var frm = doc.frm_update_ncbi_lproks;

    // download
    frm.action = '/htbin/recog_build/update_ncbi_lproks.cgi'; 
    frm.submit();

    return;
}

//
function update_gold() {
    var doc = this.document;
    var frm = doc.frm_update_gold;

    // download
    frm.action = '/htbin/recog_build/update_gold.cgi'; 
    frm.submit();

    return;
}

//
function copy_public_species_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var idx = frm.project_id.selectedIndex;
    var proj_id = frm.project_id.options[idx].value;
    var uri = '/htbin/recog_build/copy_public_species_win.cgi'
            + '?project_id=' + proj_id;
    open(uri, 'build_body');

    return;
}

//
function copy_public_species() {
    var doc = this.document;
    var frm = doc.frm_copy_species;

    frm.submit();

    return;
}

//
function list_species_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var idx = frm.project_id.selectedIndex;
    var proj_id = frm.project_id.options[idx].value;
    var uri = '/htbin/recog_build/list_species_win.cgi'
            + '?project_id=' + proj_id;
    open(uri, 'build_body');

    return;
}

//
function update_mysql_species_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var uri = '/htbin/recog_build/update_mysql_species_win.cgi';
    open(uri, 'build_body');


    return;
}

//
function update_mysql_species() {
    var doc = this.document;
    var frm = doc.frm_update_mysql_species;

    frm.action = '/htbin/recog_build/update_mysql_species.cgi';
    frm.submit();

    return;
}

//
function get_sequences_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0410get_sequences.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function exec_blast_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0420exec_blast.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function exec_blast_detail_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0120clear_blast_status.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function exec_blast_spec_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0130clear_blast_spec_status.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function exec_motif_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0440exec_motif.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function update_mysql_homology_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0450update_homology.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function build_homology_db_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0510build_homology_db.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function build_homology_db_spec_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0520build_homology_db_spec.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function build_misc_db_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0530build_misc_db.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function publish_db_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0610publish.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function disp_spec(sta, fc) {
    var elm_list = getElementsByClassName('fc_'+fc);
    var elm;
    for(var i = 0; i < elm_list.length; i++) {
        elm = elm_list[i];
        elm.style.display = sta;
    }

    return;
}

//
function disp_all_spec(sta) {
    var all_fc = new Array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
                           'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
                           'u', 'v', 'w', 'x', 'y', 'z',
                           'ug');

    for (var i = 0; i < all_fc.length; i++) {
        var c = all_fc[i];
        disp_spec(sta, c);
    }

    return;
}

//
function select_spec_all() {
    disp_all_spec('inline');

    set_width('spid',     '100px');
    set_width('spname',   '120px');
    set_width('fullname', '300px');
    set_width('abbrev',   '100px');
    set_width('strain',   '150px');
    set_width('taxid',     '50px');

    return;
}

//
function select_spec() {

    disp_all_spec('none');

    for (var i = 0; i < select_spec.arguments.length; i++) {
        var fc = select_spec.arguments[i];
        disp_spec('inline', fc);
    }
    set_width('spid',     '100px');
    set_width('spname',   '120px');
    set_width('fullname', '300px');
    set_width('abbrev',   '100px');
    set_width('strain',   '150px');
    set_width('taxid',     '50px');

    return;
}

//
function set_width(name, w) {
    var elm_list = getElementsByClassName(name);
    var elm;
    for(var i = 0; i < elm_list.length; i++) {
        elm = elm_list[i];
        elm.style.width = w;
    }

    return;
}

//
function list_species_set_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var idx = frm.project_id.selectedIndex;
    var proj_id = frm.project_id.options[idx].value;

    var uri = '/htbin/recog_build/list_species_set_win.cgi'
            + '?proj_id=' + proj_id;

    frm.action = uri;
    frm.submit();

    return;
}

//
function make_species_set_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0360make_species_set.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function set_select_species_set(name) {
    var elm = document.getElementById('selected_species_set');
    elm.innerHTML = name;
}

//
function select_species_set_win() {
    var http_req = get_http_req();
    var params = '';

    //
    var uri = 'b0370select_species_set.html';
    http_req.open('post', uri, true);
    http_req.send(params);
    http_req.onreadystatechange = function() {
        if (http_req.readyState != 4) {
            return;
        }

        var elm_body = document.getElementById('body');
        elm_body.innerHTML = http_req.responseText;
    };

    return;
}

//
function publish_db() {
    if (!document.f0.sta_site_ok.checked) {
        alert('Please check');
        return;
    }

    alert('Published');

    return;
}

//
function select_public_species_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var idx = frm.project_id.selectedIndex;
    var proj_id = frm.project_id.options[idx].value;
    var uri = '/htbin/recog_build/organism_selection_recog.cgi'
            + '?project_id=' + proj_id;
    open(uri, 'organism_selection');

    return;
}

//
function add_user_genome_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var uri = '/htbin/recog_build/add_user_genome_win.cgi';
    open(uri, 'win_add_user_genome');

    return;
}

//
function list_user_genome_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var uri = '/htbin/recog_build/list_user_genome_win.cgi';
    open(uri, 'build_body');

    return;
}

//
function select_user_genome_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    var idx = frm.project_id.selectedIndex;
    var proj_id = frm.project_id.options[idx].value;
    var uri = '/htbin/recog_build/select_user_genome_win.cgi'
            + '?project_id=' + proj_id;
    open(uri, 'build_body');

    return;
}

//
function select_user_genome() {
    var doc = this.document;
    var frm = doc.frm_select_user_genome;

    frm.submit();

    return;
}

//
function del_public_species(proj_id, spid) {
    var doc = this.document;

    var sta = confirm('Delete from this project?');
    if (!sta) {
        return;
    }

    var uri = '/htbin/recog_build/del_public_spec_proj.cgi'
            + '?project_id=' + proj_id
            + '&spid=' + spid;
    open(uri, 'build_body');

    return;
}

//
function update_user_genome() {
    var doc = this.document;
    var frm = doc.frm_add_user_genome;

    if (frm.taxid.value == '') {
        frm.taxid.focus();
        alert('Please input taxonomy id.');
        return;
    }

    frm.action = '/htbin/recog_build/mod_user_genome.cgi';
    frm.target = '';
    frm.submit();

    return;
}

//
function mod_user_genome(spid) {
    var doc = this.document;
    var frm = doc.frm_mod_user_genome;

    frm.spid.value = spid;
    frm.target = 'win_mod_user_genome';
    frm.action = '/htbin/recog_build/mod_user_genome.cgi';
    frm.submit();

    return;
}

//
function del_user_genome(spid) {
    var doc = this.document;
    var frm = doc.frm_mod_user_genome;

    var sta = confirm('Delete from this genome?');
    if (!sta) {
        return;
    }

    frm.spid.value = spid;
    frm.target = 'win_del_user_genome';
    frm.action = '/htbin/recog_build/del_user_genome.cgi?spid=spid';
    frm.submit();

    return;
}

//
function download_public_species(spid) {
    var doc = this.document;
    var frm = doc.frm_upd_public_spec;

    frm.spid.value = spid;
    frm.submit();

    return;
}

//
function exec_blastdp_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    //
    frm.action = '/htbin/recog_build/exec_blastdp_win.cgi'; 
    frm.submit();

    return;
}

//
function exec_blastdp() {
    var doc = this.document;
    var frm = doc.frm_exec_blastdp;

    //
    frm.action = '/htbin/recog_build/exec_blastdp.cgi'; 
    frm.submit();

    return;
}

//
function insert_blastdp_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    //
    frm.action = '/htbin/recog_build/insert_blastdp_win.cgi'; 
    frm.submit();

    return;
}

//
function insert_blastdp() {
    var doc = this.document;
    var frm = doc.frm_insert_blastdp;

    //
    frm.action = '/htbin/recog_build/insert_blastdp.cgi'; 
    frm.submit();

    return;
}

//
function build_homology_db_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    //
    frm.action = '/htbin/recog_build/build_homology_db_win.cgi'; 
    frm.submit();

    return;
}

//
function build_homology_db() {
    var doc = this.document;
    var frm = doc.frm_build_homology_db;

    //
    frm.action = '/htbin/recog_build/build_homology_db.cgi'; 
    frm.submit();

    return;
}

//
function publish_recog_win() {
    var doc = this.document;
    var frm = doc.frm_build;

    //
    frm.action = '/htbin/recog_build/publish_recog_win.cgi'; 
    frm.submit();

    return;
}

//
function publish_recog() {
    var doc = this.document;
    var frm = doc.frm_publish_recog;

    //
    frm.action = '/htbin/recog_build/publish_recog.cgi'; 
    frm.submit();

    return;
}

//////////
