#!/usr/bin/perl -s
use strict;
use MBGD;
use MbgdUserGenomeCommon;
require "MBGD_Conf.pl";

###############################################################################
#
sub clearUserGenomeTable {
    my($db) = shift;
    my($tab);

    foreach $tab ($db->list_tables()) {
        if ($main::MERGE_ONLY && $tab =~ /_user$/i) {
            next;
        }

        my($sql) = "drop table $tab;";
        $db->do($sql);
    }

    return;
}

###############################################################################
#
sub createUserGenomeTables {
    my($dbname) = shift;
    my($mrgTabSrc) = shift;
    my($tabName);
    my(@tabList) = ('Genome',
                    'DNASeq',
                    'GeneSeq',
                    'ProteinSeq',
                    'Chromosome',
                    'Gene',
                    'Homology',
                    'Motif',
                    'ProtMotif');
#@tabList = ('DNASeq');
#@tabList = ('Homology');

    if ($dbname =~ /^mbgd$/i) {
        print STDERR "WARNING :: dbname is 'mbgd'!!\n";
        return;
    }
    if ($dbname =~ /^mbgd_work$/i) {
        print STDERR "WARNING :: dbname is 'mbgd_work'!!\n";
        return;
    }
    if ($dbname =~ /^mbgd_accum$/i) {
        print STDERR "WARNING :: dbname is 'mbgd_accum'!!\n";
        return;
    }

    #
    my($db);
    my($dbOpt) = {};
    my($try) = 3;
    while($try--) {
        $dbOpt->{'new'} = 1;
        $db = new MBGD::DB("dbi:mysql:$dbname", $dbOpt);
        if ($db->{'conn'} !~ /^\s*$/) {
            # ³
            print STDERR "SUCCESS :: connect $dbname\n";
            # ơ֥
            clearUserGenomeTable($db);
            last;
        }

        # ³
        # DB ¸ߤʤȻפ ===> DB 
        print STDERR "create $dbname\n" if ($main::DEBUG);
        $db = new MBGD::DB("", $dbOpt);
        my($sql) = "create database if not exists $dbname;";
        $db->do($sql);
        $db->disconnect();
    }
    if ($db->{'conn'} =~ /^\s*$/) {
        # Ǥ³
        print STDERR "ERROR :: Can not connect to DB[$dbname]\n";
        exit(-1);
    }

    # 桼ơ֥
    if (! $main::MERGE_ONLY) {
        foreach $tabName (@tabList) {
            my($opt) = {};
            $opt->{'tablename'} = lc($tabName) . "_user";
            my($tab) = new MBGD::DBTable($db,
                                         $tabName,
                                         $opt);

            # create_table() ᥽åɤȤ $MBGD_HOME/schema ʲ
            # $dbname, user, base ν Schema 
            # 桼Ȥ˥ܥå󥯤
            $tab->create_table();
        }
    }

    # merge ơ֥
    foreach $tabName (@tabList) {
        my($tab) = new MBGD::DBTable($db,
                                     $tabName);

        my($opt) = {};
        $opt->{'merge_table'} = sprintf("type=merge union=(%s.%s,%s_user) insert_method=last", $mrgTabSrc, lc($tabName), lc($tabName));
        $tab->create_table($opt);
    }

    return;
}


###############################################################################
if ($0 eq __FILE__) {
    my($uid) = shift(@ARGV);
    if (! $uid) {
        print STDERR "Usage :: $0 UID\n";
        exit(-1);
    }

    #
    my($dbExt) = '';
    if ($main::ACCUM) {
        $dbExt = '_accum';
    }

    #
    my($dbname);
    my($fileOld, $fileNew);

	my(%patchDbName) = (''       => '',
                        '_accum' => '' );


    #
    $dbname = MbgdUserGenomeCommon::getDbname($uid);
    $fileOld = "$ENV{'MBGD_HOME'}/schema/mbgd". $patchDbName{"$dbExt"} ."$dbExt";
    $fileNew = "$ENV{'MBGD_HOME'}/schema/$dbname$dbExt";
    symlink($fileOld, $fileNew);
    createUserGenomeTables("$dbname$dbExt",
                           "mbgd" . $patchDbName{"$dbExt"} . $dbExt);
#    unlink($fileNew);
}

###############################################################################
1;#
###############################################################################
