#!/usr/bin/perl -s

###############################################################################
use MBGD;
require "MBGD_Conf.pl";

###############################################################################
$CHKLEV_homology  = 90;
$CHKLEV_protmotif = 90;
###############################################################################
#
sub getAllSpec {
    my($db) = @_;
    my($tab, $opt);
    my($res);
    my($ent);
    my($refSpList) = [];

    # DB ʪΰ
    $tab = "genome";
    $opt->{'columns'} = "sp";
    $res = $db->select_fetch($tab, $opt);
    foreach $ent (@{$res->{'INFO'}}) {
        push(@{$refSpList}, $ent->{'sp'});
    }

    return $refSpList;
}

###############################################################################
#
sub getProtseqCountSp {
    my($db, $sp) = @_;
    my($tab, $opt);
    my($res);
    my($ent);
    my($n);

    # Υ
    $tab = "gene";
    $opt->{'columns'} = "count(distinct(aaseq)) n";
    $opt->{'where'} = "sp='$sp'";
    $res = $db->select_fetch($tab, $opt);
    ($ent) = @{$res->{'INFO'}};
    $n = $ent->{'n'};

    return $n;
}

###############################################################################
#
sub getHomologyCountSp {
    my($db, $sp) = @_;
    my($tab, $opt);
    my($res);
    my($ent);
    my($n);

    $tab = "gene g, proteinseq ps, homology h";
    $opt->{'columns'} = "count(distinct(g.aaseq)) n";
    $opt->{'where'} = "g.sp='$sp' and g.aaseq=ps.id and ps.chksum=h.name1 and h.name1=h.name2";
    $res = $db->select_fetch($tab, $opt);
    ($ent) = @{$res->{'INFO'}};
    $n = $ent->{'n'};

    return $n;
}

###############################################################################
#
sub getProtmotifCountSp {
    my($db, $sp) = @_;
    my($tab, $opt);
    my($res);
    my($ent);
    my($n);

    # ո̿Υ
    $tab = "gene g, proteinseq ps, protmotif pm";
    $opt->{'columns'} = "count(distinct(g.aaseq)) n";
    $opt->{'where'} = "g.sp='$sp' and g.aaseq=ps.id and ps.chksum=pm.name";
    $res = $db->select_fetch($tab, $opt);
    ($ent) = @{$res->{'INFO'}};
    $n = $ent->{'n'};

    return $n;
}

###############################################################################
#
sub printMessage {
    my($title, $sp, $lev, $nSeq, $nSearch) = @_;

    print STDERR "$title :: $sp\n";
    if ($nSeq < $nSearch) {
        # 긡̤¿
        #     ---> ֤ OK
        print STDERR "Status :: OK";
    }
    elsif ($nSeq == $nSearch) {
        # ȸ̤οƱ
        #     ---> ֤ OK
        print STDERR "Status :: OK";
    }
    elsif ($nSeq * $lev / 100 <= $nSearch) {
        #  $lev ʾ帡̤ο
        #     ---> ֤ OK
        print STDERR "Status :: OK";
    }
    else {
        # ̤οʤ
        #     ---> ֤ NG
        print STDERR "Status :: NG";
    }
    print STDERR "(sequences=$nSeq : found recs=$nSearch)\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname);
    my($db);
    my(@spList) = @ARGV;
    my($title);
    my($sp);

    # DB ³
    $dbname = $main::MYSQL_DBACCUM;
    $db = MBGD::DB->new($dbname);

    if (scalar(@spList) == 0) {
        my($refSpList) = &getAllSpec($db);
        push(@spList, @{$refSpList});
    }

    foreach $sp (@spList) {
        my($nSeq);
        my($nHomology);
        my($nProtmotif);

        # ƥǡμ
        $nSeq       = &getProtseqCountSp($db, $sp);
        $nHomology  = &getHomologyCountSp($db, $sp);
        $nProtmotif = &getProtmotifCountSp($db, $sp);

        $title = "Check homology count";
        &printMessage($title, $sp, $main::CHKLEV_homology, $nSeq, $nHomology);

        $title = "Check protmotif count";
        &printMessage($title, $sp, $main::CHKLEV_protmotif, $nSeq, $nProtmotif);
    }
    exit;
}

###############################################################################
1;#
###############################################################################
