#!/usr/bin/perl -s

###############################################################################
# *.embl Υե *.gbk Ѵ
#
###############################################################################

###############################################################################
#
sub ConvEmbl2Gbk {
    my($file) = @_;
    my($line);
    local(*FH);

    open(FH, "$file") || die("Can not open $file($!)");
    while($line = <FH>) {
        chomp($line);

        if ($line =~ /^XX/) {
            next;
        }
        elsif ($line =~ /^ID\s+(\S+)/) {
            $ac = $1;
            ($isCircular) = ($line =~ /\s(circular)\s/i);
            ($len) = ($line =~ /\s(\d+)\s+BP/);
        }
        elsif ($line =~ /^AC\s+(\S+);/) {
            $ac = $1;
        }
        elsif ($line =~ /^SV\s+(\S+)/) {
            $ver = $1;
        }
        elsif ($line =~ /^DT\s+(\S+)/) {
	    # take only the last line when there are multiple lines.
            $date = $1;
        }
        elsif ($line =~ /^DE\s+(.+)$/) {
            $descr .= " " if ($descr ne '');
            $descr .= $1;
        }
        elsif ($line =~ /^OS\s+(.+)$/) {
	    $source = $1;
        } elsif ($line =~ /^RN\s+\[(\d+)\]/) {
	    $refnum = $1;
        } elsif ($line =~ /^RP\s+(\S+)/) {
		my($from,$to) = split(/\-/, $1);
		$ref[$refnum]->{from} = $from;
		$ref[$refnum]->{to} = $to;
	} elsif ($line =~ /^RX\s+(\S.+)$/) {
		my $line = $1;
		if ($line =~ /MEDLINE;\s*(\d+)/) {
			$ref[$refnum]->{medid} = $1;
		} elsif ($line =~ /PUBMED;\s*(\d+)/) {
			$ref[$refnum]->{medid} = $1;
		}
	} elsif ($line =~ /^RA\s+(\S.+)$/) {
		push(@{$ref[$refnum]->{authours}}, $1);
	} elsif ($line =~ /^RT\s+(\S.+)$/) {
		push(@{$ref[$refnum]->{title}}, $1);
	} elsif ($line =~ /^RL\s+(\S.+)$/) {
		push(@{$ref[$refnum]->{journal}}, $1);
	} elsif ($line =~ /^FH\s+Key\s+/) {
            print "LOCUS       $ac $len bp DNA $isCircular BCT $date\n";
            print "DEFINITION  $descr\n";
            print "ACCESSION   $ac\n";
            print "VERSION     $ver\n" if ($ver);
            print "SOURCE      $source.\n";
	    if ($refnum) {
		for ($r = 1; $r <= $refnum; $r++) {
			my $from = $ref[$r]->{from};
			my $to = $ref[$r]->{to};
			printf "REFERENCE   %-2s (bases $from to $to)\n", $r;
			my $authours = $ref[$r]->{authours};
			print "  AUTHORS   ", $authours->[0], "\n";
			foreach $l (@{$authours}[1..$#{$authours}]) {
				print "            $l\n";
			}
			my $journals = $ref[$r]->{journal};
			print "  JOURNAL   ", $journals->[0], "\n";
			foreach $l (@{$journals}[1..$#{$journals}]) {
				print "            $l\n";
			}
			if ($ref[$r]->{medid}) {
				print "  MEDLINE   $ref[$r]->{medid}\n";
			}
		}
	    }
            print "FEATURES             Location/Qualifiers\n";
        }
        elsif ($line =~ /^FT/) {
            $line =~ s#^FT#  #;
            print $line, "\n";
        }
        elsif ($line =~ /^SQ\s+/) {
            ($a) = ($line =~ /(\d+)\s+A;/i);
            ($c) = ($line =~ /(\d+)\s+C;/i);
            ($g) = ($line =~ /(\d+)\s+G;/i);
            ($t) = ($line =~ /(\d+)\s+T;/i);
            ($o) = ($line =~ /(\d+)\s+other;/i);

            print "BASE COUNT $a a $c c $g g $t";
            print " $o others" if (0 < $o);
            print "\n";
            print "ORIGIN\n";

            my($idx);
            $idx = 1;
            while($line = <FH>) {
                chomp($line);

                if ($line =~ m#^//#) {
                    print $line, "\n";
                    last;
                }

                $line =~ s#^\s+##;
                $line =~ s#\s*\d+\s*$##;
                printf("%9d $line\n", $idx);
                $idx += 60;
            }
            last;
        }
    }
    close(FH);

}

###############################################################################
if ($0 eq __FILE__) {
    my($file);

    foreach $file (@ARGV) {
        &ConvEmbl2Gbk($file);
    }
}

###############################################################################
1;#
###############################################################################
