#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD;
use MbgdUserGenomeCommon;
require "InfoSpec.pl";

sub checkSpidTab {
    my($filename) = shift;

    my($refSpidTab) = getInfoSpecTab($filename);

    foreach my $spdir (<$main::DIR_species/g[mud][0-9][0-9][0-9]*>) {
#print STDERR "$spdir\n";
	my($uginfo) = MbgdUserGenomeCommon::loadUgInfo("$spdir/gm/genome.txt");
	addInfoSpecTabEntry($refSpidTab, $uginfo->{spid}, $uginfo->{sp}, $spdir);
    }

    setInfoSpecTab($filename, $refSpidTab);
}

if ($0 eq __FILE__) {
    my($filename) = shift(@ARGV);
    $filename = $main::FILE_spidtab if (! $filename);

    checkSpidTab($filename);
}

1;#
