#!/usr/bin/perl -s

use MBGD;
require 'commonLib.pl';
require "MBGD_common.pl";

if (! $main::DIR) {
    $main::DIR = $main::DIR_db_uniprot;
}

$xref_embl_file = "$main::DIR/xref_embl.tab";
$xref_embl_table = "xref_embl";
$xref_embl_schema = "(uni_id char(15) not null,
		uni_acc char(8) not null,
		embl_acc char(15) not null,
		embl_protid char(15) not null,
		status varchar(64),
		moltype varchar(64),
		KEY (uni_acc),
		KEY (embl_protid),
		KEY (uni_id) )";

$xref_file = "$main::DIR/xref.tab";
$xref_table = "xref";
$xref_schema = "(uni_acc char(8) not null,
		x_db char(20) not null,
		x_acc char(20) not null,
		x_name varchar(128) not null,
		status varchar(128) not null,
		KEY (uni_acc),
		KEY (x_db,x_acc) )";

    #
	system("$main::CMD_mysqladmin create uniprot > /dev/null 2>&1");


$db = MBGD::DB->new("dbi:mysql:uniprot");

#&create_table($db, $xref_embl_table, $xref_embl_schema);
#&load_table($db, $xref_embl_file, $xref_embl_table);
&load_data_into_new_table($db, $xref_embl_file,
		$xref_embl_table, $xref_embl_schema);

#&create_table($db, $xref_table, $xref_schema);
#&load_table($db, $xref_file, $xref_table);
&load_data_into_new_table($db, $xref_file, $xref_table, $xref_schema);

$db->disconnect;


sub insert_table {
	my($infile, $table, $schema) = @_;
	if ($db->exist_table("$table")) {
		$db->drop_tables("$table");
	}
	$db->execute("drop table if exists $table");
	$db->execute("create table $table $schema");
	$db->execute("load data local infile '$infile' into table $table");
	$db->flush_table("$table");
}
