#!/usr/bin/perl -s
use strict;
use File::Path;
use FileHandle;
require "MBGD_common.pl";

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 [-DIR=dir] /file/path/to/gene2accession.gz\n";
}

###############################################################################
#
sub createNcbiGeneDb {
    my($dir) = shift;
    my($fileGene2Accession) = shift;
    my($cmd);

    #
    chdir($dir);

    #
    if ($main::DOWNLOAD) {
        my($fileGene) = "gene2accession.gz";
        if (-e "$fileGene") {
            $cmd = "$main::CMD_cp -p $fileGene $fileGene.bak";
            system("$cmd");
        } else {
            new FileHandle(">$fileGene.bak");
        }

        print STDERR "Download :: gene2accession.gz\n";
        my($url) = "ftp://ftp.ncbi.nih.gov/gene/DATA/gene2accession.gz";
        $cmd = "$main::CMD_curl -L -O $url";
        system("$cmd");

        $cmd = "$main::CMD_cmp -s $fileGene $fileGene.bak";
        my$sta = system("$cmd");
        unlink("$fileGene.bak") if (-e "$fileGene.bak");
        if (($sta >> 8) == 0) {
            print "Found no changes.\n";
            exit(0);
        }

        $fileGene2Accession = "$dir/gene2accession.gz";
    }

    #
    print STDERR "Decompress :: gene2accession.gz\n";
    $cmd = "$main::CMD_gzip -dc $fileGene2Accession > gene2accession";
    system("$cmd");

    #
    $cmd = "$ENV{'MBGD_HOME'}/build/insertNCBIGene.pl -DIR=$dir";
    system("$cmd");

    unlink("gene2accession");

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dir) = $main::DIR;
    if (! $main::DIR) {
        $dir = $main::DIR_db_gene;
    }
    mkpath($dir, 0, 0750) if (! -e "$dir");

    #
    my($fileGene2Acc) = "$main::DIR_ftp_gene/gene2accession.gz";
    if (! -e "$fileGene2Acc") {
        $main::DOWNLOAD = 1;
        $fileGene2Acc = "$main::DIR_db_gene/gene2accession.gz";
    }

    createNcbiGeneDb($dir, $fileGene2Acc);
}

1;#
