#!/usr/bin/perl -s


###############################################################################
# GenBank Υǡɲä줿å
#     FTP Υǥ쥯ȥ˿ǥ쥯ȥ꤬ ---> ǡɲ
# å塢ʪ̾ܥǥ쥯ȥ̾򵭽ҤƤե򹹿
#
#
# Usage : $0  [options]  [ base-dir ... ]
#     options       : -INS  ɲä줿ʪ STDERR ˽
#                     -UPD  줿ʪ STDERR ˽
#                     -DEL  줿ʪ STDERR ˽
#     base-dir      : GenBank ΥǡեǼǥ쥯ȥ
#                     .../genbank/genomes/Bacteria 
#
# Ȥ
#   % $0 [/db/bio/ftp/ncbi-ftp/genbank/genomes/Bacteria]
#
#
###############################################################################
require "MBGD_Conf.pl";
require "CheckGbkFile.pl";
require "InfoSpec.pl";
require "MBGD_common.pl";
require "MBGD_commonUpdate.pl";

###############################################################################
# FTP ǥ쥯ȥˤ륵֥ǥ쥯ȥ̾ʪ̾ˤ Key 
sub searchSpec {
    my($baseDir) = @_;
    my($file);
    my($info);
    my($refHash);
    my($n);
    local(*DH);

    $info = {};
    $n = 0;
    opendir(DH, "$baseDir") || die("Can not open $baseDir($!)");
    foreach $file (sort(readdir(DH))) {
        next if ($file =~ /^\./);
        next if (! -d "$baseDir/$file");

        $refHash = &CheckGbkFile($baseDir, $file);
        if ($refHash) {
            print STDERR "Found spec-dir : ", $file, "\n" if ($DEBUG);
            $info->{"$file"} = $refHash;
            $n++;
        }
    }
    closedir(DH);

    if ($n == 0) {
        print STDERR "WARNING :: No spec data file found !!($baseDir)\n";
    }

    return $info;
}


###############################################################################
# ʪιʿ//
sub checkSpecStatus {
    my($infoSpecTab, $infoNew) = @_;
    my($sp, $file);
    my($info);

    $info = {};
    $info->{'INS'} = {};
    $info->{'UPD'} = {};
    $info->{'DEL'} = {};

    foreach $sp (sort(keys(%{$infoNew}))) {
        if (! defined($infoSpecTab->{'DIR2SPID'}->{"$sp"})) {
            # infoSpecTab ˤʤ ---> ɲä줿ʪ
            $infoSpecTab->{'DIR2SPID'}->{"$sp"} = "";
            $info->{'INS'}->{"$sp"} = 1;
            next;
        }
    }

    foreach $sp (sort(values(%{$infoSpecTab->{'SPID2DIR'}}))) {
        if (! defined($infoNew->{"$sp"})) {
            # New ˤʤ ---> 줿ʪ
            my($abb) = $infoSpecTab->{'DIR2SPID'}->{"$sp"};
            delete($infoSpecTab->{'SPID2DIR'}->{"$abb"});
            delete($infoSpecTab->{'DIR2SPID'}->{"$sp"});
            $info->{'DEL'}->{"$sp"} = 1;
        }
    }

    return $info;
}

###############################################################################
if ($0 eq __FILE__) {
    my(@dirList);
    my($dirname);
    my($infoSpecTab);
    my($infoNew);
    my($infoSpecSta);
    my($hashref);
    my(@typeList, $type);

    # STDERR ˽ϤƤե˽
    &openLogfile($main::logfile);

    if (scalar(@ARGV) == 0) {
        # FTP ǥ쥯ȥ꤬ꤵʤä ---> ǥեȤFTPǥ쥯ȥ
        push(@ARGV, $FTP_BACTERIA, $FTP_FUNGI);
    }

    @dirList = @ARGV;

    # SP  FTP ǥ쥯ȥȤбɤ߹
    $infoSpecTab = &getInfoSpecTab($FILE_spidtab);

    # ǿξ
    $infoNew = {};
    foreach $dirname (@dirList) {
        print STDERR "Dirname : $dirname\n" if ($DEBUG);
        $hashref = &searchSpec($dirname);
        %{$infoNew} = (%{$infoNew}, %{$hashref});
    }

    # å
    $infoSpecSta = &checkSpecStatus($infoSpecTab, $infoNew);

    #
    @typeList = ();
    push(@typeList, "INS") if ($INS);
    push(@typeList, "UPD") if ($UPD);
    push(@typeList, "DEL") if ($DEL);
    foreach $type (@typeList) {
        foreach $sp (sort(keys(%{$infoSpecSta->{"$type"}}))) {
            print STDERR $type, " :: ", $sp, "\n";
        }
    }

    # $FILE_spectab ǿξ˹
    &setInfoSpecTab($FILE_spidtab, $infoSpecTab);

    if (scalar(keys(%{$infoSpecSta->{'INS'}})) != 0) {
        # ɲä줿ʪ郎
        print STDERR "Please edit '$FILE_spidtab'.\n";
    }

    exit();
}

###############################################################################
1;#
###############################################################################
