#!/usr/bin/perl -s

###############################################################################
# GenBank Υǡ줿å
#     $DIR_species ʲǥ쥯ȥˤեƤ
#     MD5 ƤȰۤʤäƤ
#         ---> ǡ줿
# å塢ǥ쥯ȥ̾(ʪ̾)ܥե̾MD5򵭽ҤƤե
# 
#
#
# Usage : $0  [spec1 spec2 ... specN]
#     spec1         : Ū˹ʪ̾
#
# Ȥ
#   % $0
#
#
###############################################################################
require "MBGD_Conf.pl";
require "CheckGbkFile.pl";
require "InfoSpec.pl";
require "libCheckPoint.pl";
require "libProcList.pl";
require "MBGD_commonUpdate.pl";

###############################################################################
# $DIR_species/ʪ/GB Υե뤬줿å
sub checkSpecMd5 {
    my($infoMd5, $skip_ignore) = @_;
    my($baseDir) = "$DIR_species";
    my($info);
    my($file);
    my($refHash);
    local(*DH);

    $info = {};
    opendir(DH, "$baseDir") || die("Can not open $baseDir($!)");
    foreach my$spid (readdir(DH)) {
        next if ($spid !~ /^gm\d{5}$/);
        next if ($spid =~ /^\./);
        next if (! -d "$baseDir/$spid");

        #
	if (-d "$baseDir/$spid/GB/ignore") {
		$refHash = &CheckGbkFile("$baseDir/$spid", "GB/ignore", "md5");
		$flag_ignore = 1;
	} else {
		$refHash = &CheckGbkFile("$baseDir/$spid", "GB", "md5");
		$flag_ignore = 0;
	}
        if (! $refHash) {
	# not a data directory
            next;
        }

        foreach $file (keys(%{$refHash})) {
            if ($infoMd5->{"$spid"}->{"$file"} ne $refHash->{"$file"}) {
                # different from the previous md5 value

                if ($infoMd5->{"$spid"}->{"$file"} eq '') {
                    print STDERR "New file :: $file\n";
                }
                else {
                    print STDERR "Updateed :: $file\n";
                }

		if (! ($skip_ignore && $flag_ignore) ) {
	                $info->{"$spid"} = 1;

		# replace md5 value with new one
       	        	$infoMd5->{"$spid"} = $refHash;
		}
                last;
            }
        }
    }
    closedir(DH);

    return $info;
}

###############################################################################
if ($0 eq __FILE__) {
    my($fileInfoSpecMd5);
    my($infoSpecMd5);
    my($infoNew);
    my($infoSpecSta);
    my($hashref);
    my(@typeList, $type);
    my(@forcedUpdSpecList);
    my(@updSpecList);
    my($proc, @procList);
    my($procname);
    my($ret);

    if (scalar(@ARGV) < 0) {
        print STDERR "Usage $0 [spec1 spec2 ... specN]\n";
        exit();
    }

    # STDERR ˽ϤƤե˽
    &openLogfile($main::logfile);

    # ǡե MD5
    $fileInfoSpecMd5 = "$DIR_mbgdhome/etc/specfile.md5";

    # ʪ
    @forcedUpdSpecList = @ARGV;

    # ʪǡե MD5 ɤ߹
    $infoSpecMd5 = &getInfoSpecMd5($fileInfoSpecMd5);

    print STDERR "Now checking data file.\n";
    $info = &checkSpecMd5($infoSpecMd5);

    # add specified species forced to be updated
    foreach $sp (@forcedUpdSpecList) {
        $info->{"$sp"} = 1;
    }

    @updSpecList = sort(keys(%{$info}));
    foreach $sp (@updSpecList) {
        print STDERR "Updating $sp\n";
        @procList = ( { 'title'    => "m0310ConvGB2Mbgd_$sp",
                        'procname' => "$DIR_build/m0310ConvGB2Mbgd.pl",
                        'opt'      => "-nolog $sp" },
                      { 'title'    => "m0330MakeSptit_$sp",
                        'procname' => "$DIR_build/m0330MakeSptit.pl",
                        'opt'      => "-nolog $sp" },
#                      { 'title'    => "m0320GetFuncCategory_$sp",
#                        'procname' => "$DIR_build/m0320GetFuncCategory.pl",
#                        'opt'      => "-nolog $sp" },
#                      { 'title'    => "m0320GetFuncCategory_$sp",
#                        'procname' => "$DIR_build/m0320GetFuncCategory.pl",
#                        'opt'      => "-nolog -kegg $sp"},
        );
        &doProcList(@procList);
    }

    # ǿ MD5 ͤϤ
    &setInfoSpecMd5($fileInfoSpecMd5, $infoSpecMd5);

    exit();
}

###############################################################################
1;#
###############################################################################
