#!/usr/bin/perl -s

###############################################################################
# DB ʪξϿ
#
# ϿѤߤΥǡϿʤ褦ˤ
#     ιhomology table ˤŤǡ SKIP 
#
# Usage : $0
#
###############################################################################
use DirHandle;
use FileHandle;
use File::Path;
use MBGD;
use MbgdUpdate;
use RecogBuild;
use RECOG::RecogProject;
require "MBGD_Conf.pl";
require "InfoSpec.pl";
require "libMBGDaxes.pl";
require "libCheckPoint.pl";
require "MBGD_commonUpdate.pl";

###############################################################################
# оݤȤʤ spec ǡõ
sub getFileTimestamp {
    my($file) = @_;
    my($stamp);
    my($sec, $min, $hour, $day, $mon, $year);

    if (! -e "$file") {
        # ե뤬ʤ
        $stamp = "20010101000000";        # 2001/01/01 00:00:00
    }
    else {
        ($sec, $min, $hour, $day, $mon, $year) = localtime((stat("$file"))[9]);
        $year += 1900;
        $mon++;
        $stamp = sprintf("%04d%02d%02d%02d%02d%02d", $year, $mon, $day, $hour, $min, $sec);
    }

    return $stamp;
}

###############################################################################
#
sub InsertSpecInfo {
    my($db) = shift;
    my(@specList);
    my($spid);
    my($db, $opt);
    my($cmd);
    my($ret);
    my($procname);
    my($genome, @genomeList);
    my($ver);
    my($g);

    my($fh_sta);
    if ($main::FILE_STA) {
        $fh_sta = IO::File->new(">$main::FILE_STA");
    }

    #
    mkpath("$DIR_work", 0, 0750);

    my(@spListUnf);
    my(@spListDel);
    my(@spListKep);
    my(@spListNew) = RecogBuild::selectUpdSpecInfo();

    # ʪǡϿ
    $procname = "m0400NewProtseq";
    my($fileChkPoint) = "$DIR_work/.$procname.end";
    if (! -e "$fileChkPoint") {
        new FileHandle(">$fileChkPoint");
    }

    # ȤǡʹߤϿ줿 proteinseq Ф
    my($date);
    if ($main::DATE) {
        $date = $main::DATE;
    }
    else {
        my($db) = MBGD::DB->new($main::MYSQL_DBACCUM);
        my($sql) = "show table status like 'homology'";
        my($sth) = $db->execute($sql);
        my($ref) = $sth->fetchrow_hashref();

        my($key) = 'Update_time';
        my($upd_date, $upd_time) = split(/\s+/, $ref->{"$key"});
        $date = $upd_date;
    }

    # ǡϿ
    $db = MBGD::DB->new($main::MYSQL_DBACCUM);
    foreach $spid (@spListNew) {
        print STDERR "DBG :: START [$spid]\n";
        if ($fh_sta) {
            $fh_sta->print("Update :: $spid\n");
        }

        $procname = "m0420UpdateSpecInfo";
        my($fileChkPoint) = "$DIR_work/.${procname}_$spid.end";
        if (-e "$fileChkPoint") {
            next;
        }

        # MySQL ϿƤ(proteinseq) *.protseq Ӥ롣
        my($sta) = MbgdUpdate::matchSpecSequence($db, $spid);
        if (! $sta) {
            # 󤬹Ƥ
            print STDERR "DBG :: Proteinseq was changed.($spid)\n";
            my($sql) = "update project set mbgd_update=NULL where spid='$spid'";
            $db->do($sql);
        }

        $cmd = "$DIR_build/$procname.pl -nolog -DEBUG='$DEBUG' $opt $spid";
        $ret = &procCheckPoint("${procname}_$spid", $cmd);
        die("STOP :: $procname ($ret)") if ($ret);
    }

    if ($fh_sta) {
        $fh_sta->print("Collecting new protein sequences\n");
    }

    # spid.tab եƤ spid Ф
    my($infoSpec) = getInfoSpecTab($FILE_spidtab);
    my(@spid_list) = sort(keys(%{$infoSpec->{'SPID2DIR'}}));

    $procname = "m0450GetProteinSeq";
    my($fileChkPoint) = "$DIR_work/.${procname}.end";
    $cmd = "$DIR_build/$procname.pl -nolog -DEBUG='$DEBUG' $opt @spid_list";
    $ret = &procCheckPoint("${procname}", $cmd);
    die("STOP :: $procname ($ret)") if ($ret);

    # оμ
    my($spList) = join(',', @spListNew);
    $procname = "m0490SelectUpdSeq";
    if (! -f "$DIR_work/newprotseq") {
	## newprotseq file is not created
	&clearCheckPoint1($procname);
    }
    $cmd = "$DIR_build/$procname.pl -nolog -DEBUG='$DEBUG' $opt -PROJECT -SPEC=$spList -DATE=$date";
    $ret = &procCheckPoint($procname, "$cmd > $DIR_work/newprotseq");
    die("STOP :: $procname ($ret)") if ($ret);

    if ($fh_sta) {
        $fh_sta->close();
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    # STDERR ˽ϤƤե˽
    &openLogfile($main::logfile);

    #
    my($db) = MBGD::DB->new($main::MYSQL_DBACCUM);

    InsertSpecInfo($db);

    exit;
}

###############################################################################
1;#
###############################################################################
