#!/usr/bin/perl -s

use File::Path;
require "MBGD_common.pl";

if (! -e "$main::FILE_TIGRFAMS.rps") {
    print STDERR "Can not found TIGRFAMs.\n";
    exit(0);
}


#if (! defined $TMPDIR) {
#	$TMPDIR = "$MBGD_tmp";
#}

if (! $OUTNAME) {
	$OUTNAME = "tmp_dom_$$";
	if ($TMPDIR) {
		$OUTNAME = "$TMPDIR/$OUTNAME";
	}
}

$blastout="$OUTNAME.domtop";
$resultfile="$OUTNAME.out";

$motdbfile = $main::FILE_tigrfams;
if (! defined $NAMELEN) {
	$NAMELEN = 22;	# the length of MD5 value; for check
}

$retainTmp = 1; # temporal
$retainTmp = 0 if ($deleteTmp);

$qseqfile=$ARGV[0];
$resultfile=$ARGV[1] if ($#ARGV >= 1);

die "Usage: $0 qseqfile\n" if (! $qseqfile);
die "$0: $qseqfile: file not found\n" if (! -f $qseqfile);

$ENV{'PATH'} .= ":/dbb/project/MBGD/package/mqblast";

if ($TMPDIR && ! -d $TMPDIR) {
	mkpath($TMPDIR);
}

if ($RETRY) {
	die "You must specify MQBLAST_TMPDIR\n" if (! $MQBLAST_TMPDIR);
	die "directory not exist: $MQBLAST_TMPDIR\n" if (! -d $MQBLAST_TMPDIR);
	$OTHEROPT .= "-ADD -TMPDIR='$MQBLAST_TMPDIR' ";
}
if ($retainTmp) {
	$OTHEROPT .= "-retainTmp ";
}

my($modeQsub) = '';
if ($main::CMD_qsub && -x $main::CMD_qsub) {
    $modeQsub = '-mode=qsub -CopyAll';
}

$cmd = "$main::CMD_mqblast -OUTFILE='$blastout' "
     . "-CMD_rpsblast=$main::CMD_rpsblast "
     . "$modeQsub -CopyDB=0 -PROCNUM=$main::NUM_cpu "
     . "-BLKSIZ=200 -BLASTOPT='-e 1' -BLASTFMTOPT='-m 0' "
#     . "-CHECK "
#     . "-CHECK_NAMELEN1=$NAMELEN "
     . "-PROGNAME='rpsblast' "
     . $OTHEROPT
     . "$motdbfile $qseqfile";
print STDERR "Exec :: $cmd\n" if ($main::DEBUG);
system("$cmd");

#
$fileCutoff = $main::FILE_tigrfams . ".cutoffs";
$cmd = "$main::CMD_readRpsBlastDomTop -DOMTOP -cutoff_file='$fileCutoff' $blastout > $resultfile";
print STDERR "Exec :: $cmd\n" if ($main::DEBUG);
system("$cmd");

#unlink($blastout);
