#!/usr/bin/perl -s
use strict;
use IO::Dir;
use IO::File;
require "MBGD_Conf.pl";

###############################################################################
sub cleanup {

    my($dir) = "$ENV{'MBGD_HOME'}/work";
    my($dh) = IO::Dir->new("$dir") || die("Can not open $dir($!)");
    while (my$file=$dh->read()) {
        if ($file =~ /^homology\.blastdpres\.out/) {
            unlink("$dir/$file");
        }
        elsif ($file =~ /^newprotseq/) {
            unlink("$dir/$file");
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    cleanup();
}
###############################################################################
1;#
###############################################################################
