#!/usr/bin/perl -s

###############################################################################
# Copy flat file data.
#   at first copying DIR_currentdb -> DIR_workdb,
#      then copying DIR_work -> DIR_workdb
###############################################################################
use DirHandle;
use File::Basename;
use File::Path;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require "libChangeTabs.pl";

###############################################################################
#
sub CopyDbDir {
    my($file);
    my(@fileList);

    mkpath("$DIR_database.work", 0, 0750);

    @fileList = (@UPD_dirList, @UPD_fileList);

  $main::verbose = 1;

  if (! $main::add || $main::add eq 'force') {
    foreach $file (@fileList) {
        next if (! -e "$DIR_database.work/$file");

        print STDERR "remove $DIR_database.work/$file\n";
        $cmd = "$CMD_rm -rf $DIR_database.work/$file";
        system("$cmd");
    }
  }

    print STDERR "Copy $DIR_work to $DIR_database.work\n";
    foreach $f (@fileList) {
	    &copyFiles("$DIR_work/$f", "${DIR_database}.work/$f",
			{rename => 1});
    }

    ## link (non-updated) current files onto work directory
    print STDERR "Link $DIR_database on $DIR_database.work\n";
    foreach $f (@fileList) {
	    &copyFiles("$DIR_database/$f", "${DIR_database}.work/$f",
			{link => 1});
    }

    foreach my$f ('tax.*') {
        my($cmd) = "$main::CMD_mv $DIR_work/$f ${DIR_database}.work/";
        system("$cmd");
    }

    return;
}
sub RemoveWorks {
	@fileList = (@UPD_dirList, @UPD_fileList);
    	foreach $f (@fileList) {
		if (-f "$DIR_work/$f") {
	       		unlink("$DIR_work/$f");
		} elsif (-d "$DIR_work/$f") {
	       		rmtree("$DIR_work/$f");
		}
	}
}

###############################################################################
if ($0 eq __FILE__) {
    &openLogfile($log);

    &CopyDbDir() if (! $index);
#    if (! $main::retainWork) {
#	&RemoveWorks();
#    }

    exit;
}

###############################################################################
1;#
###############################################################################
