#!/usr/bin/perl -s
use strict;
use File::Path;
use IO::File;
use LWP::UserAgent;
use HTTP::Request::Common;
require "MBGD_Conf.pl";
require "InfoSpec.pl";

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 [-DIR='database.work'] spec1 [spec2 .. specN]\n";
    print STDERR "             spec :: e.g. gm00001 , hin\n";

    return;
}

###############################################################################
#
sub sort_blastdpres {
    my($dir_out) = shift;
    my(%download_sphash) = @_;

    #
    my(@splist) = sort(keys(%download_sphash));

    foreach my$sp (@splist) {
        my($file_bldp_old) = "$dir_out/tmp_blastdpres.$sp";
        my($file_bldp_new) = "$file_bldp_old.$$";
        my($file_bldp_tmp) = $download_sphash{"$sp"};
        my($cmd) = "$main::CMD_sort ";
        $cmd .= "$file_bldp_old " if (-e "$file_bldp_old");
        $cmd .= "$file_bldp_tmp | $main::CMD_uniq > $file_bldp_new";
#print STDERR "CMD :: $cmd\n";
        print STDERR "Sorting... $sp\n";
        system("$cmd");

        #
        unlink("$file_bldp_old.bak");
        rename("$file_bldp_old", "$file_bldp_old.bak");
        rename("$file_bldp_new", "$file_bldp_old");
        unlink("$file_bldp_tmp");
    }

    return;
}

###############################################################################
#
sub mirrorBldpData {
    my($dir_bldp) = shift;
    my(@sp_list) = @_;

    print STDERR "Downloading...\n";

    #
    my($file_response) = "$dir_bldp/tmp_download.$$";
    my($cgi) = 'http://mbgd.genome.ad.jp/htbin/RECOG/getData';
    my($args_ref) = { 'table' => 'homology',
                      'key'   => join(',', @sp_list),
                    };
    my($request) = POST($cgi, $args_ref);
    my($ua) = LWP::UserAgent->new();
    my($response) = $ua->request($request, $file_response);
    if (!$response->is_success()) {
        die("Can not download bldp.");
    }

    my($fhr) = IO::File->new("$file_response") || die("Can not open $file_response($!)");
    my($fhw);
    my($prev_sp1);
    my(%download_sphash);
    while (my$line=$fhr->getline()) {
        my($spname1, $spname2) = split(/\s/, $line);
        my($sp1, $name1) = split(/\:/, $spname1);
        if ($prev_sp1 ne $sp1) {
            if ($fhw) {
                $fhw->close();
            }
            my($file_bldp) = "$dir_bldp/tmp_dl_blastdpres.$sp1.$$";
            $download_sphash{"$sp1"} = $file_bldp;
            print STDERR "Writing... $file_bldp\n";
            $fhw = IO::File->new(">$file_bldp") || die("Can not open $file_bldp($!)");
        }

        $fhw->print($line);

        $prev_sp1 = $sp1;
    }
    $fhr->close();

    #
    sort_blastdpres($dir_bldp, %download_sphash);

    #
    unlink($file_response);

    print STDERR "Done.\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    #
    my($fileSpidTab) = "$main::FILE_spidtab";
    if (($main::FILE ne '') && -f $main::FILE) {
        $fileSpidTab = $main::FILE;
    }
    my($refSpidTab) = getInfoSpecTab($fileSpidTab);

    my(@spid_list);
    if ($main::SPIDTAB) {
        push(@spid_list, keys(%{$refSpidTab->{'SPID2NAME'}}));
    }

    #
    my(%spec_hash);
    foreach my$spec (@ARGV, @spid_list) {
        $spec_hash{"$spec"} = 1;
    }
    my(@spec_list) = sort(keys(%spec_hash));

    #
    my(@sp_list);
    foreach my$spec (@spec_list) {
        my($sp);
        if (exists($refSpidTab->{'SPID2NAME'}->{"$spec"})) {
            $sp = $refSpidTab->{'SPID2NAME'}->{"$spec"};
        }
        elsif (exists($refSpidTab->{'NAME2SPID'}->{"$spec"})) {
            $sp = $spec;
        }
        else {
            print STDERR "WARNING :: Unknown species [$spec]\n";
            next;
        }

        push(@sp_list, $sp);
    }

    #
    my($dir_db) = 'database.work';
    my($dir_bldp) = sprintf("%s/%s/bldp", $ENV{'MBGD_HOME'}, $dir_db);
    if ($main::DIR) {
        $dir_bldp = $main::DIR;
    }
    mkpath("$dir_bldp", 0, 0750) if (!-e "$dir_bldp");

    #
    print STDERR "Download bldp. [@sp_list]\n";
    mirrorBldpData($dir_bldp, @sp_list);
}

###############################################################################
1;#
###############################################################################
