#!/usr/bin/perl -s

###############################################################################
#
# RpsBlast ν̤ɤ߹ mysqlimport ǽǽʥեѴ
#
###############################################################################

###############################################################################
#
sub readRpsBlastRes {
    my($filename) = @_;
    my($query);
    my($rank, @infoRank);
    my($hsp, @infoHsp);
    my($info);
    my($infoProtMotif);
    my($sp, $name, $from1, $to1, $motlib, $motid, $motname, $program, $from2, $to2, $score, $eval, $descr);
    my($wk);
    local(*FH);

    open(FH, "$filename") || die("Can not open $filename($!)");
    while(<FH>) {
        chomp();

        if (/^Query=(\S+)/) {
            $query = $1;
        }
        elsif (/^RANK\s+(\d+)/) {
            $rank = $1;
            @infoRank = split(/#/);
        }
        elsif (/^HSP\s+(\d+)/) {
            $hsp = $1;
            if ($hsp != 1) {
                # HSP 1 ʳϡSKIP
                next;
            }
            @infoHsp = split(/#/);

            #
            $sp                    = 'md5';
            $name                  = $infoRank[1];
            ($from1, $to1)         = split(/\-/, $infoHsp[1]);
## format has been changed !!
##            ($wk, $motlib, $motid) = split(/\|/, $infoRank[3]);
##            ($motname)             = split(/,/, $infoRank[7]);
            ($motid, $motname)             = split(/[,\.\;]*\s+/, $infoRank[7]);
            $program               = 'rpsblast';
            $from2                 = '\N';            # set NULL
            $to2                   = '\N';            # set NULL
            $score                 = $infoHsp[3];
            $eval                  = $infoHsp[5];
            $descr                 = $infoRank[7];

	    if ($motid =~ /^LOAD/i) {
		$motlib = 'Load';
	    } elsif ($motid =~ /^pfam/i) {
		$motlib = 'Pfam';
	    } elsif ($motid =~ /^smart/i) {
		$motlib = 'Smart';
            } elsif ($motid =~ /^cd/i) {
                $motlib = 'cd';
            } else {
                print STDERR "Warning: unknown motlib: $motid\n";
                $motlib = '';
	    }

            print $sp,      "\t";
            print $name,    "\t";
            print $from1,   "\t";
            print $to1,     "\t";
            print $motlib,  "\t";
            print $motid,   "\t";
            print $motname, "\t";
            print $program, "\t";
            print $from2,   "\t";
            print $to2,     "\t";
            print $score,   "\t";
            print $eval,    "\t";
            print $descr,   "\n";

        }
    }
    close(FH);

}

###############################################################################
if ($0 eq __FILE__) {
    my($refFuncUsage);
    my($filename);

    $refFuncUsage = sub {
        print STDERR "Usage : $0", "\n";
    };

    if (! @ARGV) {
	push(@ARGV, "<&STDIN");
    }
    foreach $filename (@ARGV) {
        &readRpsBlastRes($filename);
    }

    exit;
}

###############################################################################
1;#
###############################################################################
