#!/usr/bin/perl -s

###############################################################################
#
###############################################################################

#$ENV{MBGD_HOME} = '/dbb/project/MBGD/TEST';

require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require "libMBGDaxes.pl";
require "libCheckPoint.pl";
require "libMBGDClustMethod.pl";
require "defaultClustOpt.pl";

###############################################################################
#
sub makeDefaultCluster {
    my($splist, $outdir, $tabname) = @_;
    my($fileClustTree) = "$outdir/$tabname.clusterTree";
    my($fileClustTab) = "$outdir/$tabname.clusterTab";
    my($other_selopt);

if ($tabname eq 'all') {
	$other_selopt = '-NEAREST=asym -NEXT=90';
}

    ## actual command for execution
    $sel_cmd_exec = &getCmdSelect($splist, \%HOMOL,
			"-DIR='$DIR_database.work/bldp' $other_selopt");
    $clst_cmd_exec = &getCmdClust('nearest',\%HOMOL,
		$HOMOL{clusttype}, "$DIR_work/taball.domclust");

    ## command description
    $sel_cmd = &getCmdSelect($splist, \%HOMOL, $other_selopt);

    $clst_cmd = &getCmdClust('nearest',\%HOMOL,
		$HOMOL{clusttype}, '');

    ## We do not need addinfo nor sort command here.
    $addinfo_cmd = "$CMD_addinfo -cons_gene -category_col=category ";
    $sort_cmd = '';

    ## actual command for execution
    my($cmd_exec1, $cmd_exec2, $cmd_exec3)
		= &execClustOpt($sel_cmd_exec, $clst_cmd_exec, $addinfo_cmd, $sort_cmd, $splist);

    ## command description
    my($cmd_desc) = &execClustOptInfo($sel_cmd, $clst_cmd, $addinfo_cmd, $sort_cmd, $splist);


if (! ($skip_clust && -f "$fileClustTree") ) {
    $fh = new FileHandle(">$fileClustTree")
		|| die("Can not open $fileClustTree($!)");
    $fh->print("# $cmd_desc\n");
    $fh->close();
    system("$cmd_exec1 >> $fileClustTree");
}

    $fh = new FileHandle(">$fileClustTab") || die("Can not open $fileClustTree($!)");
    $fh->print("# $cmd_desc\n");
    $fh->close();

    if (! ($pid = fork)) {
        exec("$CMD_dbInsert -dbname='$UPD_dbiTmp' -tabID='$tabname' $fileClustTree");
	exit(0);
    }

    system("$CMD_cat $fileClustTree| $cmd_exec2| $cmd_exec3 >> $fileClustTab");

    $cmd = "$CMD_dbInsert2 -dbname='$UPD_dbiTmp' -tabID='$tabname' $fileClustTab";
    system("$cmd");
}

###############################################################################
if ($0 eq __FILE__) {
    my($sp);
    my(%spHash);
    my(@spList);


    $splist_all = join(',', &MBGD_SpecTableGetAllSpec());
    $splist_def = join(',', &MBGD_SpecTableGetDefaultSpecies("$DIR_database.work"));
print STDERR "$splist_all\n";
print STDERR "$splist_def\n";

    &makeDefaultCluster($splist_all, $DIR_work, 'all');
#    &makeDefaultCluster($splist_def, $DIR_work, 'default');
    exit;
}

###############################################################################
1;#
###############################################################################
