#!/usr/bin/perl -s
use strict;
use DirHandle;
use FileHandle;
use File::Path;

################################################################################
#
sub getTimestamp {
    my($file) = shift;
    my(@s) = stat($file);
    return $s[9]; # $B%U%!%$%k$rJQ99$7$?F|;~(B
}

################################################################################
#
sub sprintTime {
    my($t) = shift;
    my(@d) = localtime($t);
    return sprintf("%04d/%02d/%02d %02d:%02d:%02d", $d[5] + 1900, $d[4] + 1, $d[3],
                                                    $d[2], $d[1], $d[0]);
}

################################################################################
#
sub getLatestDate {
    my($dir) = shift;
    my($dateNewFile) = 0;

    if (-f "$dir") {
        # $B%U%!%$%k$G$"$k(B
        return getTimestamp($dir);
    }
    elsif (-d "$dir") {
        my($dh) = new DirHandle("$dir") || return time();
        foreach my$file (sort($dh->read())) {
            next if ($file =~ /^\.\.$/);  # $B?F%G%#%l%/%H%j$OBP>]30(B

            if (($file =~ '.') ||
                (-f "$dir/$file")) {
                my$t = getTimestamp("$dir/$file");
                if ($dateNewFile < $t) {
                    $dateNewFile = $t;
                }
            }
            elsif (-d "$dir/$file") {
                my$t = getLatestDate("$dir/$file");
                if ($dateNewFile < $t) {
                    $dateNewFile = $t;
                }
            }
        }
        return $dateNewFile;
    }

    return time(); 
}

###############################################################################
#
sub clearWorkDir {
    my($dir) = shift;
    my($hours) = shift;
    my($now) = time();

    if (-f "$dir") {
        # $B%U%!%$%k$G$"$k(B
        my$dateNewFile = getTimestamp($dir);
        if ($dateNewFile < $now - $hours * 3600) {
            if ($main::remove) {
                unlink("$dir");
            }
            else {
                print "TEST :: [", sprintTime($dateNewFile), "] :: unlink($dir)\n";
            }
        }
        else {
            if (! $main::remove) {
                print "TEST :: [", sprintTime($dateNewFile), "] :: skip :: $dir\n";
            }
        }
    }
    elsif (-d "$dir") {
        my($dh) = new DirHandle("$dir") || return;
        foreach my$file (sort($dh->read())) {
            next if ($file =~ /^\.$/);
            next if ($file =~ /^\.\.$/);

            my$dateNewFile = getLatestDate("$dir/$file");
            if ($dateNewFile < $now - $hours * 3600) {
                if ($main::remove) {
                    rmtree("$dir/$file");
                }
                else {
                    print "TEST :: [", sprintTime($dateNewFile), "] :: rmtree($dir/$file)\n";
                }
            }
            else {
                if (! $main::remove) {
                    print "TEST :: [", sprintTime($dateNewFile), "] :: skip :: $dir/$file\n";
                }
            }
        }
    }
}

###############################################################################
if ($0 eq __FILE__) {
    if ($main::hours <= 0) {
        print "Usage :: $0 -hours=HOURS [-remove] dir\n";
        exit(0);
    }

    print "TEST mode\n" if (! $main::remove);
    foreach my$dir (@ARGV) {
        clearWorkDir($dir, $main::hours);
    }
}

###############################################################################
1;#
###############################################################################
