#!/usr/bin/perl -s
use strict;
use DirHandle;
use File::Path;
use FileHandle;
use MBGD;
use MBGD::DB;
use MbgdUserGenomeCommon;

###############################################################################
#
sub getExpireUid {
    my($ndays) = shift;
    my(@uidList);

    my($dir) = "$ENV{'MBGD_HOME'}/MBGDUserData";
    my($dh) = new DirHandle($dir);
    foreach my$file (sort($dh->read())) {
        next if ($file =~ /^\./);

        next if (! -d "$dir/$file");

        my($fileLastAccess) = "$dir/$file/lastAccess";
        if (! -e "$fileLastAccess") {
            new FileHandle(">$fileLastAccess");
        }

        if ($ndays < -M "$fileLastAccess") {
            # $B:G8e$NMxMQ$+$i0lDj4|4V7P2a$7$?(B
            push(@uidList, $file);
        }
    }

    return @uidList;
}

###############################################################################
#
sub expireMymbgdData {
    my($uid) = shift;
    my(@fileList) = ( 'blastFinished.spec',
                      'motifFinished.spec',
                      'species',
                      'database',
                      'tmp');

    my($dirUg) = MbgdUserGenomeCommon::getDirBaseUserGenome($uid);

    #
    foreach my$file (@fileList) {
        rmtree("$dirUg/$file") if (-e "$dirUg/$file");
    }

    # UserGenome
    for(my$gid = 1; $gid <= $MbgdUserGenomeCommon::MAX_USER_GENOME; $gid++) {
        my$dir = MbgdUserGenomeCommon::getDirUserGenome($uid, $gid);
        rmtree("$dir") if (-e "$dir");
    }

    # MySQL
    my($dbname) = MbgdUserGenomeCommon::getDbname($uid);
    if ($dbname =~ /^mbgd$/i) {
        print STDERR "WARNING :: dbname is 'mbgd'!!\n";
        return;
    }
    if ($dbname =~ /^mbgd_accum$/i) {
        print STDERR "WARNING :: dbname is 'mbgd_accum'!!\n";
        return;
    }

    my($db) = new MBGD::DB("dbi:mysql:mbgd");
    my($sql) = "drop database IF EXISTS $dbname;";
    $db->do($sql);
}

###############################################################################
if ($0 eq __FILE__) {
    my(@uidList) = @ARGV;

    if ($main::ndays) {
        push(@uidList, getExpireUid($main::ndays));
    }

    foreach my$uid (@uidList) {
        print STDERR "Expire :: $uid\n";
        expireMymbgdData($uid);
    }
}

###############################################################################
1;#
###############################################################################
