#!/usr/bin/perl

use File::Basename;

@TabNames = @ARGV;
$home = $ENV{MBGD_HOME};
$WORKDIR = "$home/mysql/mbgd_work";
$CURRDIR = "$home/mysql/mbgd";

die "Usage: $0 tabnames...\n" if (! @TabNames);

foreach $t (@TabNames) {
	print "$WORKDIR/${t}.*\n";
	foreach $f (<$WORKDIR/${t}.*>) {
		$bname = basename($f);
		$curr = "$CURRDIR/$bname";
		$new = "$WORKDIR/$bname";
		$temp = "$WORKDIR/__$bname";

		if (-f "$CURRDIR/$bname") {
			rename $curr, $temp;
			rename $new, $curr;
			rename $temp, $new;
		}
	}
	system("mysqladmin refresh");
}
