#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD::DB;
use MBGD::FunctionCategory;

#
sub printUsage {
    print STDERR "Usage :: $0 -FILE_RPSBLAST=file_rps-blast_results SPEC\n";
}

#
sub readTigr {
    my($dir) = shift;
    my($ref) = {};
    my($file);
    my($fh);
    my($line);

    $file = "$dir/TIGR_ROLE_NAMES";
    $fh = new FileHandle("$file") || die("Can not open $file($!)");
    while($line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;
        my(@d) = split(/\t/, $line);

        $ref->{'ROLE_NAMES'}->{"$d[1]"}->{"$d[2]"} = $d[3];
    }
    $fh->close();

    $file = "$dir/TIGRFAMS_ROLE_LINK";
    $fh = new FileHandle("$file") || die("Can not open $file($!)");
    while($line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;
        my(@d) = split(/\t/, $line);

        $ref->{'ROLE_LINK'}->{"$d[0]"} = $d[1];
    }
    $fh->close();

    return $ref;
}

#
sub readResRpsBlast {
    my($file) = shift;
    my($fh) = new FileHandle("$file") || die("Can not open $file($!)");
    my($ref) = {};

    my($line);
    while($line = $fh->getline()) {
        $line =~ s#[\r\n]+$##;
        my(@d) = split(/\t/, $line);

        my($idx) = 0;
        my($ent) = {};

        my($qname) = 
        $ent->{'qname'}  = $d[$idx]; $idx++;
        $ent->{'qlen'}   = $d[$idx]; $idx++;
        $ent->{'tname'}  = $d[$idx]; $idx++;
        $ent->{'tlen'}   = $d[$idx]; $idx++;
        $ent->{'evalue'} = $d[$idx]; $idx++;
        $ent->{'hspNo'}  = $d[$idx]; $idx++;
        $ent->{'qfrom'}  = $d[$idx]; $idx++;
        $ent->{'qto'}    = $d[$idx]; $idx++;
        $ent->{'tfrom'}  = $d[$idx]; $idx++;
        $ent->{'tto'}    = $d[$idx]; $idx++;
        $ent->{'score'}  = $d[$idx]; $idx++;
        $ent->{'expect'} = $d[$idx]; $idx++;
        $ent->{'desc'}   = $d[$idx]; $idx++;

        # qname $B$r%-!<$K(B hash $B$K3JG<(B
        if (! exists($ref->{"$qname"})) {
            $ref->{"$qname"} = [];
        }
        push(@{$ref->{"$qname"}}, $ent);
    }
    $fh->close();

    return $ref;
}

#
sub expandSpec {
    my($db) = shift;
    my($tigr1) = shift;
    my($tigr2) = shift;
    my($ref) = shift;
    my($sp) = shift;

    #
    my($tab) = "gene g, proteinseq ps";
    my($opt) = {};
    $opt->{'columns'} = "g.sp as sp, g.name as name, ps.chksum as chksum";
    $opt->{'where'} = "g.sp='$sp' and g.aaseq=ps.id";

    my($res) = $db->select_fetch($tab, $opt);

    my($d) = "$ENV{'MBGD_HOME'}/work/tigrfams";
    mkpath($d, 0, 0750) if (! -e "$d");
    my($f) = "$d/geneFunction.$sp.tigr";
    my($fhw) = new FileHandle(">$f") || die("Can not open $f($!)");
    foreach my$refGene (@{$res->{'INFO'}}) {
        my($sp)     = $refGene->{'sp'};
        my($name)   = $refGene->{'name'};
        my($chksum) = $refGene->{'chksum'};
        if (! exists($ref->{"$chksum"})) {
            next;
        }

        my($staOut) = {};
        foreach my$r (@{$ref->{"$chksum"}}) {
            my($tname) = $r->{'tname'};
            my($tid) = $tigr2->{"ROLE_LINK"}->{"$tname"};
            my($refFunc) = $tigr1->getFunctionByOrigId($tid);
            my($lev) = $refFunc->{'LEVEL'};

            next if ($staOut->{$sp, $name, 'tigr', $lev});

            $fhw->print(join("\t", $sp, $name, 'tigr', $lev), "\n");
            $staOut->{$sp, $name, 'tigr', $lev} = 1;
        }
    }
    $fhw->close();
}

#
if ($0 eq __FILE__) {
    if (! $main::FILE_RPSBLAST) {
        printUsage();
        exit();
    }

    my($dbname) = $main::DBNAME_ACCUM;
    $dbname = $main::DBNAME if ($main::DBNAME);

    #
    my($db) = new MBGD::DB($dbname);
    my($tigr) = readTigr("/db5/project/MBGD/package/tigrfams/6.0");
    my($funcTigr) = new MBGD::FunctionCategory('tigr');
    

    my($ref) = readResRpsBlast($main::FILE_RPSBLAST);
    foreach my$sp (@ARGV) {
        expandSpec($db, $funcTigr, $tigr, $ref, $sp);
    }
}
1;#
