#include <iostream>
#include <string>
#include <sstream>
#include "ClusterInfo.h"

AllClustersInfo *AllClustersInfo::readClusters(ReadTree *rtree, string startOpt) {
	DistTree *tree;
	AllClustersInfo* retInfo = new AllClustersInfo();
	list<DistTree*> treeList;
	string start_clType, start_clustid;
	int startFlag = 1;
	if (startOpt != "") {
		istringstream ist(startOpt);
		ist >> start_clType >> start_clustid;
		startFlag = 0;
	}

	while ( (tree = rtree->readTree(&treeList)) != NULL ) {
		ClusterInfo clInfo(&treeList);
		int clustid = clInfo.getClustID();
		if (startFlag == 0) {
			if (! clInfo.checkClustID(start_clType, start_clustid)) {
				continue;
			}
			startFlag = 1;
		}

		int currIdx = retInfo->clusterInfo.size();
		clInfo.setDomInfo( &(retInfo->domInfo) );

		if (rtree->homclData.name != "") {
			retInfo->homClusterInfo.insert(pair<string,HomClusterData>(
				rtree->homclData.name, rtree->homclData));
		}

		retInfo->clusterInfo.push_back(clInfo);
		retInfo->clusterInfo_clustID_Map.insert(
			map<int,int>::value_type(clustid, currIdx));
	}
	/* index domains appearing in the original clusters */
	retInfo->domInfo.makeIndex();
	return retInfo;
}
ClusterInfo * AllClustersInfo::getClusterInfoByID(int clustid) {
	int idx = clusterInfo_clustID_Map[ clustid ];
	return &clusterInfo[ idx ];
}
ClusterInfo * AllClustersInfo::getClusterInfo(int idx) {
	return &clusterInfo[ idx ];
}
int AllClustersInfo::getClustID(int idx) {
	return clusterInfo[ idx ].getClustID();
}
DistTreeList* AllClustersInfo::getClusterTreeList(int idx) {
	ClusterInfo *clInfo = getClusterInfo(idx);
	return clInfo->getTreeList();
}
HomClusterData* AllClustersInfo::getHomClusterInfo(string homClustName) {
	map<string,HomClusterData>::iterator p = homClusterInfo.find(homClustName);
	if (p != homClusterInfo.end()) {
		return &((*p).second);
	}
	return NULL;
}

ClusterInfo::ClusterInfo(list<DistTree*>* _treeList, int _clustid) {
	treeList.setData(_treeList);
	string namestring = treeList.getName();
	string::size_type pos;
	if ( (pos = namestring.find("//")) == string::npos) {
		name = namestring;
	} else {
		upper_name = namestring.substr(0, pos);
		name = namestring.substr(pos+2);
	}
	if (_clustid == 0) {
		clustid = atoi(name.c_str());
	} else {
		clustid = _clustid;
	}
	size = 0;
}
void ClusterInfo::setDomInfo(DomInfo *domInfo) {
	int cnt = 0;
	map<string, Domain*> domMap;
	list<TreeNode *> leaves = treeList.getAllLeaves();
	int subid = 0;

	for (list<DistTree *>::iterator tre = treeList.begin(); tre != treeList.end(); tre++) {
		list<TreeNode *> leaves = (*tre)->getAllLeaves();
		for (list<TreeNode *>::iterator lv_p = leaves.begin(); lv_p != leaves.end(); lv_p++) {
			Domain *dom = (*lv_p)->getDomain();
			map<string,Domain*>::iterator dommap_p = domMap.find(dom->getDomName());
			if (dommap_p == domMap.end()) {
				/* not found */
				domInfo->addDomain(dom);
				domMap.insert( pair<string,Domain*>(dom->getDomName(),dom) );
				dom->setClustID(clustid);
				dom->addSubClustID(subid);
				cnt++;
			} else {
				dom = dommap_p->second;
				if (dom->getClustID() == clustid) {
					dom->addSubClustID(subid);
				} else {
					cerr << "duplicated gene: " << dom->getDomName() <<
						"previous: " << dom->getClustID() <<
						"; this time: " << clustid << endl;
				}
			}
		}
		subid++;
	}
/*
	list<TreeNode *>::iterator lv_p = leaves.begin();
	while (lv_p != leaves.end()) {
		Domain *dom = (*lv_p)->getDomain();
		if (domMap.find(dom->getDomName()) == domMap.end()) {
			domInfo->addDomain(dom);
			domMap.insert( dom->getDomName() );
			dom->setClustID(clustid);
			cnt++;
		}
		lv_p++;
	}
*/
	size = cnt;
}
bool ClusterInfo::checkClustID(string start_clustid, string start_clType)
{
	if (start_clType == "HomCluster") {
		return (upper_name == start_clustid);
	} else {
		return (name == start_clustid);
	}
}

ostream& operator<<(ostream& ost, const ClusterInfo& cInfo) {
        return( ost << "[" << cInfo.clustid << ": " << cInfo.upper_name << "// " << cInfo.name << " " << cInfo.size << "]" );
}
