#include <iostream>
//#include <ext/hash_map>
#include <map>
#include "Domain.h"
#include "ClusterNode.h"
#include "PairDist.h"
#include "DEBUG.h"

using namespace std;
using namespace __gnu_cxx;

ClusterNode *ClusterNode::createLeafNode(Domain *dom) {
	int count = nameHash.count(dom->getName());
	ClusterNode *n = NULL;

	if (count > 0) {
		NameHash_t::iterator p = nameHash.find( dom->getName() );
		NameHash_t::iterator up = nameHash.upper_bound( dom->getName() );
//cout << dom->getName() << endl;
		while (p != up) {
			n = p->second;
//cout << "DD: "<< *dom << " " << *(n->elem)<< endl;
			if (n->elem->getDomNum() == dom->getDomNum() ||
				(dom->getDomNum()==0 && dom->overlap(n->elem)) ) {
				return(n);
			} else if (n->elem->getDomNum() == 0) {
				nameHash.insert( pair<string,ClusterNode*>(dom->getName(), n) );
				return(n);
			}
			p++;
		}
		if (dom->getDomNum() == 0) {
cout << "D??: "<< dom->getName() << endl;
abort();
			return(NULL);
		}
	}
//cout << "DDN: "<< dom->getName() <<" " << dom->getDomNum() << endl;
/*
	if (p != nameHash.end()) {
		n = p->second;
		return(n);
	}
*/

	/* base_dom is used as a cluster node */
	Domain *base_dom = dom->getBaseDom();
	if (base_dom) {
		dom = DomainPool::create(base_dom);
	}

	n = objPool.allocate();
	n->initialize(dom);
	string sp = dom->getSpec();
	if (DEBUG::verbose_flag) {
		if (! SpecSet::checkSpecies(sp)) {
			cerr << "Warning: " << sp << " not found\n";
		}
	}
	n->spSet.setSpecSet(sp);
	SpecSetInstances *spSetInst = SpecSetInstances::getInstance();
	if (spSetInst->ignoreOnlyCluster(n->spSet)) {
		n->effCount = 0;
	} else {
		n->effCount = 1;
	}
//cout << sp << " " << spid << endl;
//	nameHash[ dom->getName() ] = n;
	nameHash.insert( pair<string, ClusterNode*>(dom->getName(), n) );
	return(n);
}
ClusterNode *ClusterNode::createIntNode(PairDist *pdist) {
	ClusterNode *cnode = objPool.allocate();
	ClusterNode *child1 = pdist->getNode(0);
	ClusterNode *child2 = pdist->getNode(1);
	cnode->initialize(child1->elem);
	cnode->child = pdist;
	cnode->count = child1->count + child2->count;
	cnode->effCount = child1->effCount + child2->effCount;
	specFlagOR(child1->spSet, child2->spSet, cnode->spSet);
	pdist->getNode(0)->unsetRootFlag();
	pdist->getNode(1)->unsetRootFlag();

/*
if (pdist->getID() >= 9170 && pdist->getID() <= 9178) {
	cout << "MERGE:"<<*cnode <<" "<<*(pdist->getNode(0)) << " " << *(pdist->getNode(1)) << endl;
}
*/
	pdist->getNode(0)->parent = pdist->getNode(1)->parent = cnode;
//cout << "isRoot=" << cnode->getChild(0)->isRoot() << " " << cnode->getChild(1)->isRoot();
	return(cnode);
}


/*
ClusterNode::ClusterNode(Domain* _elem) {
	initialize(_elem);
}
ClusterNode::ClusterNode(PairDist *pdist) {
	initialize(pdist->getNode(0)->elem);
	child = pdist;
	count = pdist->getNode(0)->count + pdist->getNode(1)->count;
	pdist->getNode(0)->isRoot = pdist->getNode(1)->isRoot = false;
	pdist->getNode(0)->parent = pdist->getNode(1)->parent = this;
}
*/
void ClusterNode::initialize(Domain* _elem) {
	elem = _elem;
	count = 1;
	id = totalNum++;
	isRootFlag = true;
	allNodes.push_back(this);
	child = NULL;
	parent=NULL;
}
void ClusterNode::reset() {
	totalNum = markedPos = 0;
	objPool.deleteAll();
	allNodes.erase(allNodes.begin(), allNodes.end());
	nameHash.erase(nameHash.begin(), nameHash.end());
}
void ClusterNode::markCurrent() {
	markedPos = allNodes.size();
}
int ClusterNode::getMarkedPos() {
	return markedPos;
}
int ClusterNode::getLastPos() {
	return allNodes.size();
}
ClusterNode *ClusterNode::getChild(int cidx) {
	if (child) {
		return (cidx == 0) ? child->getNode(0) : child->getNode(1);
	} else {
		return NULL;
	}
}
double ClusterNode::getSimValue() {
	return( child ? child->getSimValue() : 0);
}
SimValue ClusterNode::getSimValData() {
	return( child ? child->getSimValData() : SimValue::BadSimValue);
}
double ClusterNode::getScore() {
	return( child ? child->getScore() : 0);
}
double ClusterNode::getDist() {
	return( child ? child->getDist() : 0);
}

list<ClusterNode*>* ClusterNode::listRootNodes() {
	list<ClusterNode*> *ret_list = new list<ClusterNode*>();
	vector<ClusterNode*>::reverse_iterator
		p = ClusterNode::allNodes.rbegin();
	vector<ClusterNode *>::reverse_iterator
		endPos = p + (ClusterNode::getLastPos()
			   - ClusterNode::getMarkedPos());
	while (p != endPos) {
		if ((*p)->isRoot()) {
			ret_list->push_back( (*p) );
		}
		p++;
	}
	return(ret_list);
}

void ClusterNode::outputNodeScore(FILE *fp, const char *string) {
	if (child) {
		if (fp) {
/**
			if (string) {
				fprintf(fp, "%s", string);
			}
			fprintf(fp, ":score=%f:dist=%f\n",
				child->getScore(), child->getDist());
**/
			outputScoreData(fp, string, child->getScore(), child->getDist());
		} else {
			printf(" [score=%f dist=%f]",
				child->getScore(), child->getDist());
		}
	}
}
void ClusterNode::outputScoreData(FILE *fp, const char *name, const double score, const double dist) {
	if (!fp) fp = stdout;
	if (name) {
		fprintf(fp, "%s", name);
	}
	fprintf(fp, ":score=%f:dist=%f\n", score, dist);
}
vector<ClusterNode*> ClusterNode::allNodes;
MemAlloc<ClusterNode> ClusterNode::objPool(1000);
ClusterNode::NameHash_t ClusterNode::nameHash;
int ClusterNode::totalNum;
int ClusterNode::markedPos;

//class ClusterTree

