#ifndef _SIMVALUE_H_
#define _SIMVALUE_H_
#include <string>
class SimValue {
public:
	typedef enum {DIST, SCORE} ReprValue;
	typedef enum {MAX, MIN} Best;
	double score;
	double dist;
	static ReprValue reprValue;
	static Best best;
	static SimValue BadSimValue;
/*
	SimValue *BADVALUE;
	static SimValue& BadSimValue() {
		if (! BADVALUE) {
			BADVALUE = new SimValue(-999, 999);
		}
		return *BADVALUE;
	}
*/
	SimValue() {}
	SimValue(const double& _dist, const double& _score) {
		setScores(_dist, _score);
	}
	double getSimValue() const {
		return ((reprValue==SCORE) ? score : dist);
	}
	/* measure in which always larger is better */
	double getSimValueScore() const {
		return ((reprValue==SCORE) ? score : -dist);
	}
	double getScore() const {return score;}
	double getDist() const {return dist;}
	bool betterSimValue(double sim) const {
		return (reprValue==SCORE) ? (score > sim) : (sim > dist);
	}
	bool worseSimValue(double sim) const {
		return (reprValue==SCORE) ? (score < sim) : (sim < dist);
	}
	double increaseSimValue(double sim) const {
		return (reprValue==SCORE) ? (score + sim) : (dist - sim);
	}
	double decreaseSimValue(double sim) const {
		return (reprValue==SCORE) ? (score - sim) : (dist + sim);
	}
	bool operator>(SimValue& simV) {
		return betterSimValue(simV.getSimValue());
	}
	bool operator<(SimValue& simV) {
		return worseSimValue(simV.getSimValue());
	}
	void setScores(const double& _dist, const double& _score) {
		dist = _dist; score = _score;
	}
	void setDist(const double& _dist) {
		dist = _dist;
	}
	void setScore(const double& _score) {
		score = _score;
	}
	static void setReprType(std::string repr) {
		if (repr == "score") {
			reprValue = SCORE;
			best = MAX;
		} else {
			reprValue = DIST;
			best = MIN;
		}
	}
	static char getReprType() { return ((reprValue == SCORE) ? 's' : 'd'); }
};
#endif
