#!/usr/bin/perl

use Sequence;

# Class for manipulating multiple alignment information
package Alignment;

$Default_CutoffRatio = 0.6;

sub new {
	my($class) = @_;
	my($this) = {};
	bless $this, $class;
}

sub getAlignRegions {
        my($this) = @_;
	my(@AliRegions);
        foreach $aliseq (@{$this->{aliseq}}) {
		my($sqidx) = 0;
		my(@regions, $reg);
		$reg = {from=>-1, to=>-1};
		for (my $i = 0; $i < $this->{length}; $i++) {
			my($ch) = $aliseq->get_subseq($i,$i);
                        if ($ch eq '-') {
				if ($reg->{from}>=0) {
					$reg->{to} = $i;
					$reg->{toIdx} = $sqidx;
					push(@regions, $reg);
				}
				$reg = {from=>-1, to=>-1};
                        } else {
				if ($reg->{from} < 0) {
					$reg->{from} = $i;
					$reg->{fromIdx} = $sqidx;
				}
				$sqidx++;
                        }
                }
		if ($reg->{from}>=0) {
			$reg->{to} = $this->{length};
			$reg->{toIdx} = $sqidx;
			push(@regions, $reg);
		}
		push(@AliRegions, {seq=>$aliseq, regions=>\@regions});
        }
	\@AliRegions;
}
sub getConsensus {
	my($this, $cutoffRatio) = @_;
	my(@consensus);
	$cutoffRatio = $Default_CutoffRatio if (! $cutoffRatio);
	my($cutoffCnt) = $cutoffRatio * @{$this->{aliseq}};
	for (my $i = 0; $i < $this->{length}; $i++) {
		my(%charCnt, $maxChar);
        	foreach $aliseq (@{$this->{aliseq}}) {
			my($ch) = $aliseq->get_subseq($i, $i);
			$charCnt{$ch}++;
		}
		foreach my $ch (keys %charCnt) {
			$maxChar = $ch if ($charCnt{$maxChar} < $charCnt{$ch});
		}
		if ($charCnt{$maxChar} < $cutoffCnt) {
			$maxChar = ' ';	## not used in consensus
		}
		push(@consensus, $maxChar);
	}
	$this->{consensus} = \@consensus;
}
sub setAliSeq {
	my($this, $aliseq) = @_;
	$this->{aliseq} = $aliseq;
	$this->checkLength;
}
sub getAliSeq {
	my($this) = @_;
	$this->{aliseq};
}
sub getMaxNameLen {
	my($this) = @_;
	my($maxlen);
	foreach $sq (@{ $this->getAliSeq }) {
		my($len) = length($sq->{name});
		$maxlen = $len if ($maxlen < $len);
	}
	$maxlen;
}
sub checkLength {
	my($this) = @_;
	my($alilen);
	foreach my $sq (@{$this->{aliseq}}) {
		if (ref $sq eq 'Sequence') {
			$seq = $sq->getseq;
		}
		my($len) = length($seq);
		if (! $alilen) {
			$alilen = $len;
		} elsif ($alilen != $len) {
			print STDERR "Warning: lengths of the sequences in the alignment are not same: $alilen, $len\n";
			$alilen = ($alilen > $len) ? $alilen : $len;
		}
	}
	$this->{length} = $alilen;
}

# Class for reading multiple alignment information
package AlignmentFile;
sub read {
	my($class, $filename) = @_;
	my($ali) = Alignment->new;

	@seq = Sequence->read_from_fasta($filename);
	$ali->setAliSeq(\@seq);
	$ali;
}


package main;
if ($0 eq __FILE__) {
	$alifile = $ARGV[0];
	$ali = AlignmentFile->read($alifile);
	$alireg = $ali->getAlignRegions;
	foreach $regs (@{$alireg}) {
		foreach $r (@{$regs->{regions}}) {
			print join(" ", $r->{from},$r->{to}),"\n";
		}
	}
#	$cons = $ali->getConsensus;
#	print join('',@$cons),"\n";
}
1;
