#!/usr/bin/perl -s

###############################################################################
#
###############################################################################
use FileHandle;
use MBGD;
require "MBGD_Conf.pl";

package main;
###############################################################################
#
sub backupInfoSpecTab {
    my($filename) = @_;

    # ǡեΥХååפ
    for($i = 1; 0 <= $i; $i--) {
        my($fileSrc) = sprintf("%s.%d", $filename, $i);
        my($fileDst) = sprintf("%s.%d", $filename, $i + 1);

        unlink("$fileDst") if (-e "$fileDst");
        rename("$fileSrc", "$fileDst");
    }
    rename("$filename", "$filename.0");

    return;
}

###############################################################################
#
sub setInfoSpecTab {
    my($filename, $info) = @_;
    my($sp);
    my($file);
    my($i);
    my($fh);

    #
    my(@spidList);

    # MBGD Υǡ۳ϻϡspid  sp бդ̤
    # ftp ǥ쥯ȥξȤˡ¸ɬͭ
    foreach my$dir (sort(keys(%{$info->{'DIR2SPID'}}))) {
        my($spid) = $info->{'DIR2SPID'}->{"$dir"};
        my($name) = $info->{'DIR2NAME'}->{"$dir"};

        my($val);
        if (exists($info->{'COMMENTS'}->{"$dir"})) {
            $val = $info->{'COMMENTS'}->{"$dir"};
        }
        else {
            $val = join("\t", $spid, $name, $dir);
        }

        if ($val =~ /^\s*$/) {
            next;
        }
        push(@spidList, $val);
    }

    #
    $fh = new FileHandle("> $filename") || die("Can not open $filename($!)");
    $fh->print("#spid", "\t", "sp", "\t", "dir-name", "\n");
    $fh->print(join("\n", sort(@spidList)), "\n");
    $fh->close();

    return;
}

###############################################################################
#
$main::CACHE_spec_tab = {};
sub getInfoSpecTab {
    my($filename) = @_;
    my($info);
    my($sp, $file);
    my($line);
    my($ret);
    my($fh);

    if (! $filename) {
	$filename = $main::FILE_spidtab;
    }
    if (exists($main::CACHE_spec_tab->{"$filename"})) {
        return $main::CACHE_spec_tab->{"$filename"};
    }

    $info = {};
    $info->{'SPID2DIR'}  = {};
    $info->{'DIR2SPID'}  = {};
    $info->{'DIR2NAME'}  = {};
    $info->{'NAME2DIR'}  = {};
    $info->{'SPID2NAME'} = {};
    $info->{'NAME2SPID'} = {};
    $info->{'COMMENTS'}  = {};

    $line = 0;
    $fh = new FileHandle("$filename");
    if (! $fh) {
        # եΥץ󥨥顼
        print STDERR "Can not open $filename($!)" if ($DEBUG);
        return $info;
    }

    my($fileIdx) = 0;
    while(<$fh>) {
        $line++;
        s#[\r\n]*$##;

        next if (/^\s*$/);
        next if (/^\s*#spid/);

        ($spid, $name, $file) = split(/\t/);
        if ($spid =~ /^\s*#/) {
            $info->{'COMMENTS'}->{"$file"} = $_;
            next;
        }

        if ($name =~ /^\s*$/){
            # ǡФʪ̾ȥե̾ȤбդԤƤʤ
            print STDERR "WARNING!!\n";
            print STDERR "Please edit '$filename' about [$file].\n";
            next;
        }

        if ($spid && defined($info->{'SPID2DIR'}->{"$spid"})) {
            print STDERR "WARNING :: already used '$spid'.(line:$line)\n";
            next;
        }
        if (defined($info->{'NAME2SPID'}->{"$name"})) {
            print STDERR "WARNING :: already used '$name'.(line:$line)\n";
            next;
        }
        $info->{'SPID2DIR'}->{"$spid"}  = $file if ($spid);
        $info->{'DIR2SPID'}->{"$file"}  = $spid;
        $info->{'NAME2DIR'}->{"$name"}  = $file;
        $info->{'DIR2NAME'}->{"$file"}  = $name;
        $info->{'SPID2NAME'}->{"$spid"} = $name if ($spid);
        $info->{'NAME2SPID'}->{"$name"} = $spid;
        $info->{'DIR_IDX'}->{"$file"} = $fileIdx;   # spid.tab εҽݻ
        $fileIdx++;
    }
    $fh->close();

    $main::CACHE_spec_tab->{"$filename"} = $info;

    return $info;
}

###############################################################################
#
sub copyInfoSpecTabEntry {
    my($refSrc) = shift;
    my($refDst) = shift;
    my(@spidList) = @_;

    foreach my$spid (@spidList) {
        my($file) =
        $refDst->{'SPID2DIR'}->{"$spid"}  = $refSrc->{'SPID2DIR'}->{"$spid"};
        $refDst->{'DIR2SPID'}->{"$file"}  = $refSrc->{'DIR2SPID'}->{"$file"};
        my($name) =
        $refDst->{'DIR2NAME'}->{"$file"}  = $refSrc->{'DIR2NAME'}->{"$file"};
        $refDst->{'NAME2DIR'}->{"$name"}  = $refSrc->{'NAME2DIR'}->{"$name"};
        $refDst->{'SPID2NAME'}->{"$spid"} = $name;
        $refDst->{'NAME2SPID'}->{"$name"} = $spid;
        $refDst->{'DIR_IDX'}->{"$file"} = $fileIdx;   # spid.tab εҽݻ
    }

    return;
}

###############################################################################
#
sub addInfoSpecTabEntry {
    my($info) = shift;
    my($spid) = shift;
    my($name) = shift;
    my($file) = shift;

    if (! $name) {
        print STDERR "ERROR :: No name!!($spid) Can not add entry to spid.tab\n";
        return;
    }
    if (! $file) {
        print STDERR "ERROR :: No filepath!!($spid) Can not add entry to spid.tab\n";
        return;
    }

    #
    my($old_file) = $info->{'SPID2DIR'}->{"$spid"};
    delete($info->{'DIR2SPID'}->{"$old_file"});
    delete($info->{'DIR2NAME'}->{"$old_file"});

    $info->{'SPID2DIR'}->{"$spid"}  = $file if ($spid);
    $info->{'DIR2SPID'}->{"$file"}  = $spid;
    $info->{'DIR2NAME'}->{"$file"}  = $name;
    $info->{'NAME2DIR'}->{"$name"}  = $file;
    $info->{'SPID2NAME'}->{"$spid"} = $name if ($spid);
    $info->{'NAME2SPID'}->{"$name"} = $spid;

    $info->{'DIR_IDX'}->{"$file"} = scalar(keys(%{$info->{'DIR2SPID'}}));

    return;
}

###############################################################################
#
sub delInfoSpecTabEntry {
    my($info) = shift;
    my($spid) = shift;

    #
    my($old_file) = $info->{'SPID2DIR'}->{"$spid"};
    delete($info->{'DIR2SPID'}->{"$old_file"});
    delete($info->{'DIR2NAME'}->{"$old_file"});
    delete($info->{'DIR_IDX'}->{"$old_file"});

    #
    my($spec) = $info->{'SPID2NAME'}->{"$spid"};
    delete($info->{'SPID2DIR'}->{"$spid"});
    delete($info->{'NAME2DIR'}->{"$name"});
    delete($info->{'SPID2NAME'}->{"$spid"});
    delete($info->{'NAME2SPID'}->{"$name"});

    return;
}

###############################################################################
#
sub assingSpid {
    my($info) = @_;
    my($func) = sub {
        # spid.tab ˵ҤƤ¤ؤ
        $info->{'DIR_IDX'}->{"$a"} <=> $info->{'DIR_IDX'}->{"$b"};
    };

    my($maxSpid) = reverse(sort(keys(%{$info->{'SPID2DIR'}})));
    my($maxId) = ($maxSpid =~ /(\d+)$/);
    foreach my$file (sort $func keys(%{$info->{'DIR2SPID'}})) {
        if ($info->{'DIR2SPID'}->{"$file"} !~ /^\s*$/) {
            # Ǥ˺ֺѤ
            next;
        }

        $maxSpid++;
        my($spid) = sprintf("gm%05d", $maxSpid);
        my($name) = $info->{'DIR2NAME'}->{"$file"};

        $info->{'SPID2DIR'}->{"$spid"} = $file;
        $info->{'DIR2SPID'}->{"$file"} = $spid;
#        $info->{'NAME2DIR'}->{"$name"} = $file;
#        $info->{'DIR2NAME'}->{"$file"} = $name;
        $info->{'SPID2NAME'}->{"$spid"} = $name;
        $info->{'NAME2SPID'}->{"$name"} = $spid;
    }

}

###############################################################################
#
sub spid2sp {
    my($spid) = shift;
    my($filename) = shift;
    $filename = "$ENV{'MBGD_HOME'}/etc/spid.tab" if (!$filename || ! -e $filename);

    my($ref) = getInfoSpecTab($filename);

    return $ref->{'SPID2NAME'}->{"$spid"};
}

###############################################################################
# ְäƱʪ拾ɤƤ줿դ뤳
sub sp2spid {
    my($sp) = shift;
    my($filename) = shift;
    $filename = "$ENV{'MBGD_HOME'}/etc/spid.tab" if (!$filename || ! -e $filename);

    my($ref) = getInfoSpecTab($filename);

    return $ref->{'NAME2SPID'}->{"$sp"};
}

###############################################################################
#
sub setInfoSpecMd5 {
    my($filename, $info) = @_;
    my($spid);
    my($file);
    my($fh);

    $fh = new FileHandle("> $filename") || die("Can not open $filename($!)");
    $fh->print("#spid", "\t", "file-name", "\t", "MD5", "\n");
    foreach $spid (sort(keys(%{$info}))) {
        next if ($spid !~ /^g[a-z]\d{5}$/);
        foreach $file (sort(keys(%{$info->{"$spid"}}))) {
            $fh->print($spid, "\t");
            $fh->print($file, "\t");
            $fh->print($info->{"$spid"}->{"$file"}, "\n");
        }
    }
    $fh->close();

    return;
}

###############################################################################
#
sub getInfoSpecMd5 {
    my($filename) = @_;
    my($info);
    my($spid, $file, $md5);
    my($ret);
    my($fh);

    $info = {};
    $fh = new FileHandle("$filename");
    if (! $fh) {
        print STDERR "Can not open $filename($!)\n" if ($main::DEBUG);
        return $info;
    }
    while(<$fh>) {
        next if (/^\s*#/);

        s#[\r\n]*$##;
        ($spid, $file, $md5) = split(/\t/);

        $info->{"$spid"}->{"$file"} = $md5;
    }
    $fh->close();

    return $info;
}

###############################################################################
#
sub readUpdSpecInfo {
    my($info);
    my($file);
    my($fh);
    my($type, $splist);

    $file = $FILE_updspec;
    $fh = new FileHandle("$file") || die("Can not open $file($!)");
    while(<$fh>) {
        chomp();

        next if (/^\s*$/);
        next if (/^\s*#/);

        ($type, $splist) = split(/\t/);
        foreach $sp (split(/\s/, $split)) {
            $info->{"$type"}->{"$sp"} = 1;
        }
    }
    $fh->close();

    return $info;
}

###############################################################################
#
sub writeUpdSpecInfo {
    my($refSpUnfixed, $refSpDel, $refSpKeep, $refSpNew) = @_;
    my(@spUnfixed) = sort(keys(%{$refSpUnfixed}));
    my(@spDel)     = sort(keys(%{$refSpDel}));
    my(@spKeep)    = sort(keys(%{$refSpKeep}));
    my(@spNew)     = sort(keys(%{$refSpNew}));
    my($file);
    my($fh);

    $file = $FILE_updspec;
    $fh = new FileHandle(">$file") || die("Can not open $file($!)");
    $fh->print("unfixed", "\t", join(" ", @spUnfixed), "\n");
    $fh->print("del",     "\t", join(" ", @spDel),     "\n");
    $fh->print("keep",    "\t", join(" ", @spKeep),    "\n");
    $fh->print("new",     "\t", join(" ", @spNew),     "\n");
    $fh->close();
}

###############################################################################
#
sub readGenomeTxt {
    my($filename) = shift;
    my($ref) = {};

    #
    my($fh) = new FileHandle("$filename") || return $ref;
    while(my$line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;

        my($k, $v) = split(/\t/, $line);
        $ref->{"$k"} = $v;
    }
    $fh->close();

    return $ref;
}

###############################################################################
#
sub writeGenomeTxt {
    my($filename) = shift;
    my($ref) = shift;

    #
    my($fh) = new FileHandle(">$filename") || return;
    foreach my$k (sort(keys(%{$ref}))) {
        my($v) = $ref->{"$k"};

        $fh->print(join("\t", $k, $v), "\n");
    }
    $fh->close();

    return;
}

###############################################################################
1;#
###############################################################################
