#!/usr/local/bin/perl -s

package KeggAllSpecTab;

###############################################################################
#
###############################################################################
$DEFAULT_ALLSPECTAB = "/bio/etc/all_species.tab";

###############################################################################
# ѥåν
sub new {
    my($class) = shift;
    my($fileAllSpecTab) = @_;
    my($self) = {};

    bless($self, $class);

    if ($fileAllSpecTab =~ /^\s*$/) {
        $fileAllSpecTab = $DEFAULT_ALLSPECTAB;
    }
    $self->readAllSpecTab($fileAllSpecTab);

    return($self);
}

###############################################################################
#
sub readAllSpecTab {
    my($self) = shift;
    my($filename) = @_;
    my($infoAbbr);
    my($infoFile);
    my($abbr, $file, $full, $kegg, $category, $annot, $complete, $year, $ncbi);
    my($ent);
    local(*FH);

    $infoAbbr = {};
    $infoFile = {};

    open(FH, "$filename") || die("Can not open $filename($!)");
    while(<FH>) {
        chomp();

        next if (/^\s*#/);     # ȹ


        ($abbr, $file, $full, $kegg, $category, $annot, $complete, $year, $ncbi) = split(/\t/);

        $ent = {};
        $ent->{'ABBR'}       = $abbr;
        $ent->{'FILE'}       = $file;
        $ent->{'FULL'}       = $full;
        $ent->{'KEGG'}       = $kegg;
        $ent->{'CATEGORY'}   = $category;
        $ent->{'ANNOTATION'} = $annot;
        $ent->{'COMPLETE'}   = $complete;
        $ent->{'YEAR'}       = $year;
        $ent->{'NCBI'}       = $ncbi;

        $abbr =~ tr/A-Z/a-z/;
        $infoAbbr->{"$abbr"} = $ent;

        $file =~ tr/a-z/A-Z/;
        $infoFile->{"$file"} = $ent;
    }
    close(FH);

    $self->{'KEY_ABBR'} = $infoAbbr;
    $self->{'KEY_FILE'} = $infoFile;

    return;
}

###############################################################################
#
sub getInfoByAbbr {
    my($self) = shift;
    my($abbr) = @_;

    $abbr =~ tr/A-Z/a-z/;
    return $self->{'KEY_ABBR'}->{"$abbr"};
}

###############################################################################
#
sub getInfoByFile {
    my($self) = shift;
    my($file) = @_;

    $file =~ tr/a-z/A-Z/;
    return $self->{'KEY_FILE'}->{"$file"};
}

###############################################################################
package main;
if ($0 eq __FILE__) {
    my($obj);
    my($filename);

    $filename = shift(@ARGV);
    $obj = KeggAllSpecTab->new($filename);

    for(;;) {
        print "Input : ";
        $_ = <STDIN>;
        chomp();

        if (/^$/) {
            # ԤϤ줿齪λ
            last;
        }
        elsif (/^abbr:(.+)/i) {
            $info = $obj->getInfoByAbbr($1);
        }
        elsif (/^file:(.+)/i) {
            $info = $obj->getInfoByFile($1);
        }
        else {
            next;
        }

        #
        print "ABBR       : ", $info->{'ABBR'}, "\n";
        print "FILE       : ", $info->{'FILE'}, "\n";
        print "FULL       : ", $info->{'FULL'}, "\n";
        print "KEGG       : ", $info->{'KEGG'}, "\n";
        print "CATEGORY   : ", $info->{'CATEGORY'}, "\n";
        print "ANNOTATION : ", $info->{'ANNOTATION'}, "\n";
        print "COMPLETE   : ", $info->{'COMPLETE'}, "\n";
        print "YEAR       : ", $info->{'YEAR'}, "\n";
    }

    exit;
}

###############################################################################
1;#
###############################################################################
