#!/usr/local/bin/perl -s

package KeggTab;

###############################################################################
#
sub new
{
    my($type) = shift;
    return bless {}, $type;
}

###############################################################################
#
sub getName
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGTAB'}->{$spec}->{'NAME'});
}

###############################################################################
#
sub getType
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGTAB'}->{$spec}->{'TYPE'});
}

###############################################################################
#
sub getDirectory
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGTAB'}->{$spec}->{'DIRECTORY'});
}

###############################################################################
#
sub getAbreviation
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGTAB'}->{$spec}->{'ABREVIATION'});
}

###############################################################################
#
sub readKeggtab
{
    my($self) = shift();
    my($filename) = @_;
    local(*FH);

    # KEGGTAB 
    $self->{'KEGGTAB'} = {};

    open(FH, "$filename") || die "Can not open $filename($!)";
    while(<FH>) {
        if (/^\s*#*$/) {
            next;
        }

        ($name, $type, $directory, $abreviation) = split(/\s+/);
        if ($type eq 'alias') {
            # alias ϡ¸ǡ򻲾Ȥ
            $self->{'KEGGTAB'}->{$name} = $self->{'KEGGTAB'}->{$directory};
            next;
        }

        # ǥ쥯ȥ̾˴ޤޤĶѿŸ
        $directory =~ s/\$(\w+)/$ENV{$1}/g;

        $self->{'KEGGTAB'}->{$name} = {};
        $self->{'KEGGTAB'}->{$name}->{'NAME'}        = $name;
        $self->{'KEGGTAB'}->{$name}->{'TYPE'}        = $type;
        $self->{'KEGGTAB'}->{$name}->{'DIRECTORY'}   = $directory;
        $self->{'KEGGTAB'}->{$name}->{'ABREVIATION'} = $abreviation;
    }
    close(FH);
}

###############################################################################
# ޥɤȤƼ¹Ԥ줿
package main;
if ($0 eq __FILE__) {

    $obj = new KeggTab;
    $obj->readKeggtab("$ENV{'BIOROOT'}/etc/keggtab");

    while(<STDIN>) {
        chomp();
        if (/^$/) {
            last;
        }

        print $obj->getName($_), "\n";
        print $obj->getType($_), "\n";
        print $obj->getDirectory($_), "\n";
        print $obj->getAbreviation($_), "\n";
    }
}

###############################################################################
1;#
###############################################################################
