#!/usr/local/bin/perl

package MBGD;
use MBGD::Config;
#use MBGD::GenomeSet;
#use MBGD::GeneSet;
use MBGD::Genome;
use MBGD::Chromosome;
use MBGD::Homology;
use MBGD::DNASeq;
use MBGD::Sequence;
use MBGD::Gene;
use MBGD::ProtMotif;
use MBGD::Motif;
use MBGD::DB;
use DBI;
require 'MBGD_Conf.pl';

sub new {
	my($class, $opt) = @_;
	my($this) = {};
	my $classname = $class;
#	$this->{genomes} = MBGD::GenomeSet->new();
	bless $this, $class;
}

sub get {
    my($this) = shift;
	my($db, $class, $arg, $opt) = MBGD::Object::__process_args(@_);
	my $classname = &get_classname($class);
	return () if (! $classname);
	if ($arg =~ /^id=(\d+)/) {
		$arg = $1;
		return $classname->fetch($db, $arg, $opt);
	} else {
		if ($arg =~ /,/) {
			my @entries = split(',', $arg);
			$arg = \@entries;
		}
		return $classname->get($db, $arg, $opt);
	}
}
sub get_texttab {
    my($this) = shift;
	my($db, $class, $arg, $opt) = MBGD::Object::__process_args(@_);
	$opt = {} if (! $opt);
	@res = $this->get($db, $class, $arg, $opt);
	return 0 if (! @res);
	if ($opt->{count}) {
		return $res[0];
	}
	@attr = $res[0]->{schema}->get_attributes;
	my $out;
	my(@output);
	my(%fields);
	if ($opt->{fields}) {
		foreach my $f (split(/,/, $opt->{fields})) {
			$fields{$f} = 1;
		}
	}
	if (! $opt->{no_header}) {
		foreach $attr (@attr) {
			if (! $opt->{fields} || $fields{$attr}) {
				$out .= "\t" if ($out);
				$out .= "$attr";
			}
		}
		push(@output, $out);
	}
	foreach $d (@res) {
		my($out);
		foreach $attr (@attr) {
			if (! $opt->{fields} || $fields{$attr}) {
				$out .= "\t" if ($out);
				$out .= "$d->{$attr}";
			}
		}
		push(@output, $out);
	}
	@output;
}
sub get_sequence {
	my($this, $class, $name, $opt) = @_;

    #
    my(@fields);
    if (exists($opt->{'fields'})) {
        # $opt->{'fields'} $B$G!"=PNO9`L\$r;XDj2DG=$H$7$?(B
        foreach my$f (split(',', $opt->{'fields'})) {
            if ($f =~ /(sp|name|seq)/) {
                push(@fields, $1);
            }
        }
        delete($opt->{'fields'}); # $B$"$H$N8!:w=hM}$K1F6A$,=P$J$$$h$&:o=|(B
    }
    if (scalar(@fields) == 0) { # $B%G%U%)%k%H$N=PNO9`L\(B
        @fields = ('name', 'seq');
    }
    my($header) = join("\t", @fields) . "\n";

	my($seqstring) = '';
	if ($class eq 'geneseq') {
        if (!$opt->{'no_header'}) {
            $seqstring = $header;
        }
		foreach $g (MBGD::Gene->get($name, $opt)){
			next if ($opt->{chrid} && $g->{chrid} != $opt->{chrid});
			if ($g->{ntseq}) {
                my(@out);
                foreach my$f (@fields) { # $B=PNO9`L\=g$KJB$YBX$((B
                    if ($f =~ /sp/i) {
                        push(@out, $g->{sp});
                    }
                    elsif ($f =~ /name/i) {
                        push(@out, $g->{name});
                    }
                    elsif ($f =~ /seq/i) {
                        $seq = MBGD::GeneSeq->fetch($g->{ntseq});
                        push(@out, $seq->{seq});
                    }
                }
                $seqstring .= join("\t", @out) . "\n";
			}
		}
		return $seqstring;
	} elsif ($class eq 'proteinseq') {
        if (!$opt->{'no_header'}) {
            $seqstring = $header;
        }
		foreach $g (MBGD::Gene->get($name, $opt)){
			next if ($opt->{chrid} && $g->{chrid} != $opt->{chrid});
			if ($g->{aaseq}) {
                my(@out);
                foreach my$f (@fields) { # $B=PNO9`L\=g$KJB$YBX$((B
                    if ($f =~ /sp/i) {
                        push(@out, $g->{sp});
                    }
                    elsif ($f =~ /name/i) {
                        push(@out, $g->{name});
                    }
                    elsif ($f =~ /seq/i) {
                        $seq = MBGD::ProteinSeq->fetch($g->{aaseq});
                        push(@out, $seq->{seq});
                    }
                }
                $seqstring .= join("\t", @out) . "\n";
			}
		}
		return $seqstring;
	}
    else {
        return $seqstring;
    }
}
sub find_id {
	my($this, $class, @args) = @_;
	my $classname = &get_classname($class);
	my @data = $classname->find(@args);
	foreach $d (@data) {
		push(@id, $d->primary_key_value);
	}
	@id;
}
sub get_classname {
	my($class) = @_;
	my($classname);
	if ($class eq 'gene') {
		$classname = MBGD::Gene;
	} elsif ($class eq 'genome') {
		$classname = MBGD::Genome;
	} elsif ($class eq 'chromosome') {
		$classname = MBGD::Chromosome;
	} elsif ($class eq 'dnaseq') {
		$classname = MBGD::DNASeq;
	} elsif ($class eq 'proteinseq') {
		$classname = MBGD::ProteinSeq;
	} elsif ($class eq 'geneseq') {
		$classname = MBGD::GeneSeq;
	}
	$classname;
}
sub get_spnames {
	my($this) = @_;
	my $sth = $this->{genomes}->{dbtable}->query("", "sp");
	while ($g = $sth->fetchrow_array) {
		push(@sp, $g);
	}
	return @sp;
}
sub get_genomes {
	my($this, @keys) = @_;
	$this->{genomes}->get(@keys);
}
sub get_genes {
	my($this, @keys) = @_;
	$this->{genes} = MBGD::GeneSet->new();
	$this->{genes}->get(@keys);
}
sub aafasta {
	my($this, $sp) = @_;
	my $db = MBGD::DB->new;
	$sth = $db->prepare("select g.*,p.* from gene g, proteinseq p where g.aaseq=p.id and sp='$sp'");
	$sth->execute;
	while ($a = $sth->fetchrow_hashref) {
		print ">$a->{'id'} $a->{'sp'}:$a->{'name'}\n";
		print $a->{'seq'},"\n";
	}
}

1;
