#!/usr/local/bin/perl

package MBGD::DNASeq;
use MBGD::Sequence;

@ISA = qw{ MBGD::Sequence };

#sub get {
#	my($class) = shift;
#	($db, $keyvalues, $opt) = &__process_args(@_);
#	$keyvalues = [$keyvalues] if (! ref($keyvalues));
#	my @ret = $db->get_objects($class, $keyvalues, $opt);
#	return wantarray ? @ret : $ret[0];
#}
sub countN {
	my($this, $arg) = @_;
	my $seq = $this->{seq};
	my $len1 = length($seq);
	$seq =~ s/N//gi;
	my $len2 = length($seq);
	if ($arg eq 'ratio') {
		return ($len1 - $len2) / $len1;
	} else {
		return ($len1 - $len2);
	}
}
sub checkSeqStatus {
	my($this) = @_;
	if ($this->countN('ratio') <= $MBGD::Config{allowed_N_ratio}) {
		return 'complete';
	} else {
		return 'incomplete';
	}
}

sub setValues {
    my($this, $values) = @_;
    foreach my $attr (keys %{$values}) {
        if ($attr eq 'seq') {
            $values->{'seq'} = lc($values->{'seq'});
            last;
        }
    }
    $this->SUPER::setValues($values);
}

1;
