#!/usr/local/bin/perl


package MBGD::FlatTab;
use MBGD;
use FlatTab;
use MBGD::Schema;

sub new {
	my ($class, $tablename, $option) = @_;
	my $this = {};

	($tablename, $classname) = split(/:/, $tablename);
	if (! $classname) {
		$classname = $tablename;
	}
	$this->{schema} = MBGD::Schema->new($classname);
	$this->{tablename} = $this->{schema}->{classname};

	if ($option->{defaultdir}) {
		my $dirname = "$MBGD::Config{flatdata_dir}";
		system("mkdir -p $dirname");
		my $filename = "$dirname/$tablename";

		if ($option->{mode} =~ /w/i) {
			$this->{tab} = FlatTab->new({outfile=>$filename});
		} else {
			$this->{tab} = FlatTab->new({infile=>$filename});
		}
	} else {
		$this->{tab} = FlatTab->new($option);
	}

	if ($this->{schema}) {
		$this->{tab}->setFields(
			join(',', $this->{schema}->get_attributes));
	}
	bless $this, $class;
}
sub close {
	my($this) = @_;
	$this->{tab}->close;
}
sub store_object {
	my($this, $obj) = @_;
	$this->{tab}->setData($obj);
	$this->{tab}->writeData;
}

sub setData {
	my($this, $obj) = @_;
	$this->{tab}->setData($obj);
}
sub writeHeader {
	my($this) = @_;
	$this->{tab}->writeHeader;
}
sub writeData {
	my($this) = @_;
	$this->{tab}->writeData;
}

sub readData {
	my($this) = @_;
	$this->{tab}->readData;
}
sub getHash {
	my($this) = @_;
	$this->{tab}->getHash;
}

#if (__FILE__ eq $0) {
#	$t = MBGD::FlatTab->new('Genome');
#	$t->writeHeader;
#}

1;
