#!/usr/bin/perl

use MBGD::DB;
require "MBGD_Conf.pl";
package MBGD::GOLD;

sub new {
	my($class, $dbname) = @_;
	my($this) = {};
	$this->{db} = MBGD::DB->new($main::DBNAME_GOLD);
	return bless $this, $class;
}
sub getFieldList {
	my($this) = @_;
    my($db_gold) = $main::DBNAME_GOLD;
    my($sql) = "show columns from $dbname.gold";
	$sth = $this->{db}->execute($sql);
	while ($t = $sth->fetchrow_hashref) {
		push(@fieldNames, $t->{'Field'});
	}
	@fieldNames;
}
sub getInfo {
	my($this, $fields) = @_;
    my($db_gold) = $main::DBNAME_GOLD;
    my($db_mbgd) = $main::DBNAME_MBGD;
	my(%retData);
	my($goldFields);
	if (ref($fields) ne 'ARRAY') {
		my @array = split(/,/, $fields);
		$fields = \@array;
	}
	foreach my $f (@{$fields}) {
		$goldFields .= "," if ($goldFields);
		$goldFields .= "g.$f";
	}
	my($cols)  = "m.sp,$goldFields";
	my($tabs)  = "$db_mbgd.genome m, $db_gold.xref_gold_mbgd x, $db_gold.gold g";
	my($where) = "x.sp=m.sp and g.goldstamp=x.goldstamp";
	my($sql)   = "select $cols from $tabs where $where";
	$sth = $this->{db}->execute("$sql");
	while ($res = $sth->fetchrow_hashref) {
		$retData{$res->{sp}} = $res;
	}
	return \%retData;
}
1;
