#!/usr/local/bin/perl

package MBGD::Gene;
use MBGD;
use MBGD::Object;
use MBGD::GeneSeq;
use MBGD::ProteinSeq;

@ISA = qw( MBGD::Object );

##sub new {
##	inherited from Object.pm 
##}

sub setValues {
	my($this, $values) = @_;
	$this->SUPER::setValues($values);

	if (! $this->{gene} && $values->{genenames}
			&& ref($values->{genenames}) eq 'ARRAY') {
		$this->{gene} = $values->{genenames}->[0];
	}
	if ($values->{position}) {
		my($from,$to,$dir) = &get_fromto($values->{position});
		$this->{from1} = $from;
		$this->{to1} = $to;
		$this->{dir} = $dir;
	}
}

sub length {
	my($this, $type) = @_;
	my($len);
	if ($type eq 'nt') {
		$sq = MBGD::GeneSeq->fetch($this->{ntseq}, {field=>'length'});
	} else {
		if ($this->{aalen}) {
			return $this->{aalen};
		} else {
			$sq = MBGD::ProteinSeq->fetch($this->{aaseq}, {field=>'length'});
		}
	}
	return $sq->{length};
}
sub print_tab_old {
	my($this) = @_;
	my($from,$to,$dir) = &get_fromto($this->{position}, 'rev');
	print join("\t", $this->{name},
		$this->{genenames}->[0], $from, $to,
		$this->{descr});
	print "\n";
}

sub print_ntseq {
	my($this, $fh) = @_;
	return if (! $this->{ntseq});

    my($comments) = "$this->{name} [$this->{gene}] $this->{descr}";
#	$this->{ntseq}->print_fasta($comments, {'fh' => $fh});
    my$sq = MBGD::GeneSeq->fetch($this->{ntseq});
    $sq->print_fasta($comments, {'fh' => $fh});
}
sub print_aaseq {
	my($this, $fh) = @_;
	return if (! $this->{aaseq});

    my($comments) = "$this->{name} [$this->{gene}] $this->{descr}";
#	$this->{aaseq}->print_fasta($comments, $fh);
    my$sq = MBGD::ProteinSeq->fetch($this->{aaseq});
    $sq->print_fasta($comments, {'fh' => $fh});
}
sub get_region {
	my($this, $region_spec) = @_;
	my($from,$to) = ($this->{from1}, $this->{to1});
	my($f,$t) = split(/:/, $region_spec);
	local($up,$down);
	local($dir) = $this->{dir};
	if ($dir > 0) {
		($up, $down) = ($from,$to);
	} else {
		($up, $down) = ($to,$from);
	}
	$from = &regget($f);
	$to = &regget($t);
	if ($from > $to) {
		my $tmp = $to; $to = $from; $from = $tmp;
	}
	return ($from, $to);
	sub regget {
		my($regop) = @_;
		if ($regop =~ /^U\-(\d+)/) {
			return $up - $1 * $dir;
		} elsif ($regop =~ /^U\+(\d+)/) {
			return $up + ($1 - 1) * $dir;
		} elsif ($regop =~ /^D\-(\d+)/) {
			return $down - $1 * $dir;
		} elsif ($regop =~ /^D\+(\d+)/) {
			return $down + ($1 - 1) * $dir;
		}
	}
}
sub get_genomeseq {
	my($this, $db, $opt) = @_;
	my($from,$to) = ($this->{from1}, $this->{to1});
	if ($opt->{region}) {
		($from, $to) = $this->get_region($opt->{region});
	}
	my($chr) = MBGD::Chromosome->fetch($db, [$this->{chrid}]);
	my($seq) = $chr->get_subseq($from, $to, $this->{dir}, $opt);
	$seq;
}

sub get_fromto {
	my($Pos, $mode) = @_;
	if ($mode eq 'rev') {
		if ($Pos->[0]->{dir} > 0) {
			return ($Pos->[0]->{from}, $Pos->[$#{$Pos}]->{to});
		} else {
			return ($Pos->[0]->{to}, $Pos->[$#{$Pos}]->{from});
		}
	} else {
		return ($Pos->[0]->{from}, $Pos->[$#{$Pos}]->{to}, $Pos->[0]->{dir});
	}
}

sub conv_upper {
	my($name) = @_;
	($sp,$name) = split(/:/, $name);
	$sp . ":" . uc($name);
}


###############################################################################
sub keywordSearch {
    my($class, %args) = @_;
    my($db) = MBGD::DB->new;
    my($refRes);
    my($spList);
print STDERR ">>>species>>$args{species}\n";
    if ($args{'species'} ne 'all') {
    	foreach my $sp (split(',', $args{'species'})) {
        	$spList .= "," if ($spList);
        	$spList .= "'$sp'";
	}
    }

    my($keyIdx);
    my(@confField, $cond);
    my($srchCond);
    if ($args{quick} && $args{qopt} eq 'and') {
#	my $keyword = $args{query}->[0]->{keyword};
#	my $tmpkwd;
#	foreach $kw (split(/ /, $keyword)) {
#		$kw = "+$kw" if ($kw !~ /^[+-<>()~*"]/);
#		$tmpkwd .= ' ' if ($tmpkwd);
#		$tmpkwd .= $kw;
#	}
#	$args{query}->[0]->{keyword} = $tmpkwd;
	$args{query}->[0]->{keyword} = MBGD::DB::convKeywordForQuickSearch(
			$args{query}->[0]->{keyword});
    }

    foreach $qry (@{$args{query}}) {
    	my($wkCond);
        last if (! $qry->{keyword});

        if ($qry->{regexp}) {
            $qry->{keyword} =~ s#'#\\'#g;     # escape "'"
            if ($qry->{field} =~ /^orf$/) {
                $wkCond = "name REGEXP '" . $qry->{keyword} . "'";
            } elsif ($qry->{field} =~ /^gene$/) {
                $wkCond = "gene REGEXP '" . $qry->{keyword} . "'";
            } elsif ($qry->{field} =~ /^descr$/) {
                $wkCond = "descr REGEXP '" . $qry->{keyword} . "'";
            }
        } else {
            @condField = split(/(\s+and\s+|\s+or\s+)/i, $qry->{keyword});

            for($i = 0; $i < scalar(@condField); $i++) {
                $cond = $condField[$i];

		## delete space characters
                $cond =~ s#^\s*##;
                $cond =~ s#\s*$##;

                if ($i % 2 == 0) {
		    if ($condField[$i] =~ /[%_]/ && $condField[$i] !~ /\\[%_]/){
			$op = 'like';
		    } elsif ($condField[$i] =~ /\[[^\]]+\]/ ||
			$condField[$i] =~ /^\^/ || $condField[$i]=~/\$$/ ||
			$condField[$i] =~ /\*/) {
			$op = 'regexp';
		    } else {
			$op = '=';
		    }
                    if ($qry->{field} =~ /^orf$/i) {
                        $wkCond .= "name $op '$condField[$i]'";
                    } elsif ($qry->{field} =~ /^gene$/i) {
                        $wkCond .= "gene $op '$condField[$i]'";
                    } elsif ($qry->{field} =~ /^descr$/i) {
			if ($condField[$i] =~ /[\+\-\*\~\"]/) {
				$MODE = "in boolean mode";
			}
                        $wkCond .= "match(descr) against('$condField[$i]' $MODE)";
                    } elsif ($qry->{field} =~ /^all$/i || ! $qry->{field}) {
			if ($condField[$i] =~ /[\+\-\*\~\"]/) {
				$MODE = "in boolean mode";
			}
                        $wkCond .= "match(name,gene,descr) against('$condField[$i]' $MODE)";
print STDERR "CC>$wkCond\n";
                    }
                } else {
                    if ($cond !~ /and|or/) {
                        last;
                    }
                    if ($condField[$i + 1] =~ /^\s*$/) {
                        # last if the next field is not specified
                        last;
                    }

                    $wkCond .= " $cond ";
                }
            }
        }

        if ($srchCond) {
        	$srchCond .= " " . $qry->{fcond} . " ";
        }
        $srchCond .= "($wkCond)";
$ii++;
    }
    $srchCond  = "sp in ($spList) and ($srchCond)" if ($spList);
    my($srchopt) = {};
    $srchopt->{order} = "sp, name" if ( $ORDERBY eq "name" );
    $srchopt->{count} = 1;
    $srchopt->{tablename} = $args{tablename} if ($args{tablename});

    ## count hits
    $refRes->{MAXROWS} = $class->find($srchCond, $srchopt);
    delete $srchopt->{count};

    if ($args{limit} eq 'unlimited') {
    } elsif ($args{page}) {
	$begin = ($args{page}-1) * $args{limit};
	$srchopt->{limit} = "$begin,$args{limit}";
    } else {
	$srchopt->{limit} = "$args{limit}";
    }

    ## search keywords
    @results = $class->find($srchCond, $srchopt);
    foreach $r (@results) {
	my $info = {};
        $info->{'sp'}    = $r->{sp};
        $info->{'orf'}   = $r->{name};
        $info->{'gene'}  = $r->{gene};
        $info->{'descr'} = $r->{descr};
        push(@{$refRes->{'INFO'}}, $info);
    }

    return $refRes;
}

sub parseLocation {
    my($self) = shift;
    my($location) = shift || $self->{'location'};
    my($ref) = {};
    $ref->{'EXON'}   = [];
    $ref->{'INTRON'} = [];

    $location =~ s#[\<\>]##g;
    my(@exonList) = ($location =~ /(\d+\.\.\d+)/g);

    #
    my($prevEntExon);
    foreach my$exon (@exonList) {
        my($entExon) = {};
        ($entExon->{'FROM'}, $entExon->{'TO'}) = ($exon =~ /(\d+)\.\.(\d+)/);
        push(@{$ref->{'EXON'}}, $entExon);

        if ($prevEntExon) {
            my($entIntron) = {};
            ($entIntron->{'FROM'}, $entIntron->{'TO'}) = ($prevEntExon->{'TO'} + 1, $entExon->{'FROM'} - 1);
            push(@{$ref->{'INTRON'}}, $entIntron);
        }

        $prevEntExon = $entExon;
    }

    return $ref;
}

###############################################################################
1;#
###############################################################################
