#!/usr/local/bin/perl

package MBGD::ObjectSet;
use MBGD::DB;

sub new {
	my($class, $data, $opt) = @_;
	my($this) = {};
	bless $this, $class;
	if (ref $data eq 'ARRAY') {
		$this->add($data, $opt);
	}
	return $this;
}

sub add {
	my($this, $data, $opt) = @_;
	push(@{$this->{data}}, @{$data});
	if ($opt->{key}) {
		$this->set_key($opt->{key});
	}
	$this->add_index;
}
sub set_key {
	my($this, $key) = @_;
	$this->{key} = $key;
}
sub add_index {
	my($this, $data) = @_;
	if (ref $this->{key} eq 'ARRAY') {
		foreach $d (@{$data}) {
			my(@keys);
			foreach $k (@{$this->{key}}) {
				push(@keys, $d->{$k});
			}
			$key = join(':', @keys);
			push(@{$this->{hash}->{$key}}, $d);
		}
	} elsif ($this->{key}) {
		foreach $d (@{$data}) {
			$key = $d->{ $this->{key} };
			push(@{$this->{hash}->{$key}}, $d);
		}
	}
}

package main;
if ($0 eq __FILE__) {
print "STart\n";
	@g = MBGD::Gene->get("eco");
print "OK\n";
	$genes = MBGD::ObjectSet->new(\@g);
}
1;
