#!/usr/local/bin/perl

package MBGD::ProtMotif;
use MBGD::Object;

@ISA = qw( MBGD::Object );

$MOTLIB_NOT = "COG,KOG";	## use only for findMotifsForClustTab

sub getMotifs {
	my($this, @genes) = @_;
	my @ret = $this->get(\@genes);
	my $results = {};
	foreach $r (@ret) {
		push(@{$results->{"$r->{sp}:$r->{name}"}}, $r);
	}
	return $results;
}
sub findMotifsForClustTab {
	my($this, $tabid, $clustid, $opt) = @_;
	my($tmpdbname) = ($opt->{tmpdbname} ? $opt->{tmpdbname} : $main::DBNAME_TMP);
    $tmpdbname = $ENV{'MYSQL_DBTMP'} if ($ENV{'MYSQL_DBTMP'});
	my($dbname) = ($opt->{dbname} ? $opt->{dbname} : $main::DBNAME_MBGD);
    ($dbname) = ($ENV{'MYSQL_DB'} =~ /([^\:]+)$/) if ($ENV{'MYSQL_DB'});
	my($db) = MBGD::DB->new($tmpdbname);
	my($clid_list) = join(',', @{$clustid});
	my($res, $sql);
	my($where_opt);
	my($motlib_list);
	return {} if (! @{$clustid});
	if ($opt->{motif_eval}) {
		$where_opt = "m.eval <= $opt->{motif_eval}";
	}
	if ($opt->{motlib}) {
		$motlib_list = &list_to_strlist($srchopt->{motlib});
		$where_opt .= "motlib in ($motlib_list)";
	} elsif ($MOTLIB_NOT) {
		$motlib_list = &list_to_strlist($MOTLIB_NOT);
		$where_opt = "m.motlib not in ($motlib_list)";
	}
	if (@{$clustid} >= 1000) {
		$sql = "select m.sp,m.name,m.motlib,m.motid,m.motname"
			. " from $dbname.protmotif m";
		$sql .= " where 1 ";
		if ($opt->{splist}) {
			my $splist = join("','", @{$opt->{splist}});
			$sql .= " and m.sp in ('$splist') ";
		}
	} else {
		$sql= "select m.sp,m.name,m.motlib,m.program,m.motid,m.motname"
			. " from cluster_$tabid c, $dbname.protmotif m"
			. " where c.sp=m.sp and c.name=m.name"
			. "   and c.clustid in ($clid_list)";
	}
	$sql .= " and $where_opt" if ($where_opt);

	my $sth = $db->execute($sql);
	$res = {};
	while (my $r = $sth->fetchrow_hashref) {
		my $mot = $this->new($r);
		push(@{$res->{"$r->{sp}:$r->{name}"}}, $mot);
	}
	$res;
}
sub findMotifs {
	my($this, $genes, $srchopt) = @_;
	my($whereCond, $list, $getopt);
	my($db) = MBGD::DB->new;
	my($qnum, $results);

	if ($srchopt->{motlib}) {
		$list = &list_to_strlist($srchopt->{motlib});
		$whereCond .= "motlib in ($list)";
#	} elsif ($MOTLIB_NOT) {
#		$list = &list_to_strlist($MOTLIB_NOT);
#		$whereCond .= " and " if ($whereCond);
#		$whereCond .= "motlib not in ($list)";
	}
	$getopt->{add_cond} = $whereCond;

	if ($srchopt->{order}) {
		$getopt->{order} = "$srchopt->{order}";
	} else {
		$getopt->{order} = "eval";
	}

	if (! ref $genes){
		$genes = [$genes];
		$qnum = 1;
	}

	my @ret = $this->get($genes, $getopt);
	if ($qnum == 1) {
		$results = \@ret;
	} else {
		$results = {};
		foreach $r (@ret) {
			push(@{$results->{"$r->{sp}:$r->{name}"}}, $r);
		}
	}
	return $results;
}
sub list_to_strlist 
{
	my($list) = @_;
	my($db) = MBGD::DB->new;
	my($whereCond, @a);
	if (! ref $list) {
		@a = split(/,/,$list);
		$list = \@a;
	}
	if ((ref $list) eq 'ARRAY') {
		foreach my $e (@{$list}){
			$whereCond .= $db->{conn}->quote($e) . ",";
		}
	}
	chop $whereCond;
	$whereCond;
}
sub findGenes {
	my($this, $orgset, $motlist, $opt) = @_;
	my($query, @query, @motlist);
	if (ref $motlist) {
		if (ref $motlist eq 'ARRAY') {
			@motlist = $motlist;
		}
	} else {
		@motlist = ($motlist);
	}
	if (! @motlist) {
		warn "no motif list\n";
		return;
	}
	foreach $mot (@motlist) {
		my($motlib, $motid) = split(/:/, $mot);
		push(@query,  " (motlib='$motlib' and motid='$motid') ");
	}
	$query = join(" or ", @query);
	if ($orgset) {
		my $ref = ref $orgset;
		if ($ref eq ARRAY) {
			$orgset = join(',', @{$ref});
		} elsif (! $ref) {
			$orgset = "'".join("','", split(',', $orgset))."'";
		}
		$query = " ($query) and sp in ($orgset)";
	}
	if ($opt->{evalcut}) {
		$query .= " and eval <= $opt->{evalcut}";
	}
	my(@ret) = $this->find($query);
	return @ret;
}

1;
