#!/bin/perl

package MBGD::SQL_Pg;
use MBGD::SQL;
@ISA = qw {MBGD::SQL};

use DBI;
use MBGD::DB;

sub drop_table {
	my($this, $db, $tablename) = @_;
	my(@SQL, $sql);

	push(@SQL, "drop table $tablename");
	my $sth = $db->execute( "select relname from pg_class " .
		"where relname like '${tablename}_%_seq'" );
	foreach $seq ( $sth->fetchrow_array ) {
		push(@SQL, "drop sequence $seq");
	}

	@SQL;
}
sub copy_table {
	my($this, $table, $newtable, $opt) = @_;
	my($field) = '*';
	my $sql = "create table $newtable $opt->{table_opt} " .
		"select $field from $table";
	if ($opt->{condition}) {
		$sql .= " where $opt->{condition}";
	}
	$sql;
}

sub get_idval {
	my($this, $tablename) = @_;
	return "select currval('${tablename}_id_seq')";
}

sub table_options {
	my($this) = @_;
	return '';
}

sub type_convert_2 {
	my($this, $attrinfo) = @_;
	my ($type, $option) = $this->SUPER::type_convert_2($attrinfo);

	if ($attrinfo->{type} eq 'ID') {
		$type = 'serial';
	} elsif ($attrinfo->{type} eq 'TIMESTAMP') {
		$option .= ' default current_timestamp';
	} elsif ($attrinfo->{type} eq 'tinyint') {
		$type = 'smallint';
	} elsif ($attrinfo->{type} eq 'mediumtext') {
		$type = 'text';
	}

	return ($type, $option);
}

1;
