#!/usr/local/bin/perl

#$sc = Schema->new;
#$sc->load("<&STDIN", "test");
#print $sc->convSQL;

package MBGD::Schema;
use File::Basename;
use MBGD;
use MBGD::Config;

%Classes;
%Types;
$read = 0;

sub new {
	my($class, $classname, $dbname) = @_;
	my($this) = {};

    ## singleton class: to ensure that only one object is created
    ##		for a particular class
	$sc_classname = &get_schema_classname($classname);

	return $Classes{$sc_classname} if ($Classes{$sc_classname});

	&read_types if (! $read);
	$read = 1;

	bless $this, $class;
	$Classes{$sc_classname} = $this;
	$this->{dbname} = $dbname;
	$this->{classname} = $sc_classname;
	$this->{perl_classname} = $classname;
	if (! $this->load($classname, $dbname)) {
		die "Can't find schema file for $classname\n";
	}
	return $this;
}
sub DESTROY {
   ## NOTE: This object will not be destroyed automatically even when all
   ## of its referrences are removed, due to the referrence from %Classes.
	my $this = shift;
	delete $Classes{$this->{classname}};
}

sub load {
	my($this, $classname, $dbname) = @_;
	my($flag);
	my(%no_inherit, $no_inherit_flag);
	my $filename = &get_schema_path($classname, $dbname);

	if (open(F, $filename)) {
		while (<F>) {
			if (/^#!NO_INHERIT\s*(\S+)/) {
				$field = $1;
				if ($field =~ /\((.*)\)/) {
					$field = $1;
				}
				$this->{noinherit}->{$field} = 1;
			} elsif (/^#!NO_INDEX\s*(\S+)/) {
				$field = $1;
				if ($field =~ /\((.*)\)/) {
					$field = $1;
				}
				$this->{noindex}->{$field} = 1;
			}
		}
		close(F);
	}
	
	if (! $no_inherit_flag) {
		my @clnames = eval "\@{${classname}::ISA}";
		foreach $clname0 (@clnames) {
			$flag = $this->load($clname0, $dbname); 
		}
	}

#	if (! $filename && $classname) {
#	} elsif (! $classname) {
#		($classname, $path, $type) = fileparse($filename, '\..*');
#	}

#	my $clname0 = $classname;
#	while ($clname0 && ! -f $filename) {
#		## try to find schema of the first parent class
#		$clname0 = eval "\${${clname0}::ISA}[0]";
#		$filename = &get_schema_path($clname0);
#	}

#	open(F, $filename) || die "Can't find schema file for $classname\n";
	open(F, $filename) || return $flag;
	$this->{filename} = $filename;
	while (<F>) {
		chomp;
		if (/^#/) {
			if (/^#!PRIMARY_KEY\s*(\S.*)/) {
				$stmt = $1;
				$stmt =~ s/^\((.*)\)/\1/;
				@{$this->{option}->{PRIMKEY}} = split(/,/,$stmt);
			} elsif (/^#!COMPOSITE\s*(\S.*)/) {
				my($class, $attribute) = split(/\t/, $1);
				$this->{option}->{COMPOSITE}->{$class}
					= $attribute;
			} elsif (/^#!NO_INHERIT/) {
			} elsif (/^#!NO_INDEX/) {
			} elsif (/^#!(\S*)\s*(\S.*)/) {
				($type, $subtype) = split(/:/, $1);
				$stmt = $2;
				push(@{$this->{option}->{$type}}, 
					{subtype=>$subtype, content=>$stmt});
			}
			next;
		}
		($name, $type, $option) = split(/\t/);
		next if ($this->{noinherit}->{$name});

		if (! $this->{attr}->{$name}) {
			push(@{$this->{attrlist}}, $name);
		}
		my $attrinfo = {type=>$type, option=>$option};
		MBGD::SQL::type_convert_1($attrinfo);
		if ($attrinfo->{type} eq 'ID') {
			$this->{identifier} = $name;
			$attrinfo->{mask_for_insert} = 1;
		} elsif ($attrinfo->{type} eq 'TIMESTAMP') {
			$attrinfo->{mask_for_insert} = 1;
		} elsif ($attrinfo->{type} =~ /^REF\(([^\)]*)\)/i) {
			my ($refclass,@opt) = split(/,/, $1);
			$this->{foreign}->{$name} = $refclass;
		}
		$this->{attr}->{$name} = $attrinfo;
	}
	close(F);
	return 1;
}
sub print {
	my($this) = @_;
	foreach my $attr (@{$this->{attrlist}}) {
		print "$attr\t";
		print "$this->{attr}->{$attr}->{type}\t";
		print "$this->{attr}->{$attr}->{option}\n";
	}
}
sub convSQL {
	my($this, $sql_generator, $opt) = @_;
	my($SQL, @SQL);
	my($tablename) = $opt->{tablename};
	my($tempopt);
	my(@attrlist);
	my($dbms) = $sql_generator->{drvtype};
	my($optMergeTable) = $sql_generator->merge_table_options($opt);
	my(@indexForMerge);

print STDERR "## >>>$sql_generator,$sql_generator->{drvtype}<<\n" if ($main::DEBUG);
	$tablename = $this->{classname} if (! $tablename);
	if ($opt->{temporal}) {
		$tempopt = 'temporary';
		@attrlist = $this->get_attributes({for_insert=>1});
	} else {
		@attrlist = @{$this->{attrlist}};
	}

###	$SQL = "create ${tempopt} table ${tablename} (\n";

	$SQL = $sql_generator->create_table_header($tempopt, $tablename);

	my $flag = 0;
	foreach my $attr (@attrlist) {
		my $attrinfo = $this->{attr}->{$attr};
		$SQL .= ",\n" if ($flag);
		($type, $option) = $sql_generator->type_convert_2($attrinfo);
		$SQL .= "$attr $type $option";
		$flag++;
	}

	if (!$opt->{temporal} && $dbms ne 'CSV' && $this->{option}->{PRIMKEY}) {
		$SQL .= ",\nprimary key(" .
			join(',', @{$this->{option}->{PRIMKEY}}) . ")";
	}
#	elsif ($optMergeTable ne '') {
#		my($wkstmt) = {};
#		$wkstmt->{'subtype'} = '';
#		$wkstmt->{'content'} = 'unique(' . join(',', @{$this->{option}->{PRIMKEY}}) . ')';
#		push(@indexForMerge, $wkstmt);
#	}
	if ($dbms ne 'CSV' && $this->{option}->{SQL}) {
		foreach my $stmt (@{$this->{option}->{SQL}}) {
			if (! $stmt->{subtype} ||
					($stmt->{subtype} eq $dbms &&
					$stmt->{subtype} ne "!$dbms")) {
				$SQL .= ",\n$stmt->{content}";
			}
		}
	}

if (1) {
	if (scalar(@indexForMerge) != 0) {
		unshift(@{$this->{option}->{INDEX}}, @indexForMerge);
	}
	if (!$opt->{temporal} && $dbms ne 'CSV' && $this->{option}->{INDEX}) {
		my(@indexKey) = @{$this->{option}->{INDEX}};
		foreach my $stmt (@indexKey) {
			if (! $stmt->{subtype} ||
					($stmt->{subtype} eq $dbms &&
					$stmt->{subtype} ne "!$dbms")) {
				my ($idxtype, $fields) =
					($stmt->{content} =~ /(\w*)\s*\((.*)\)/);
				if ($this->{noindex}->{$fields}) {
					# suppress inheritance
					next;
				}
				if (($optMergeTable ne '') && ($idxtype =~ /fulltext/i)) {
					# illegal option at merge-table
					next;
				}
#				elsif (($optMergeTable ne '') && ($idxtype =~ /uniq/i)) {
#					# unique index --> index
#                    $idxtype = '';
#				}
				my @fldnames = split(/,/, $fields);
				my $flag = 1;
				foreach $fname (@fldnames) {
					if (! $this->{attr}->{$fname}) {
						$flag = 0; last;
					}
				}
				next if (! $flag);
				my $fldnames = join('_', @fldnames);
				
				$idx_name = "${tablename}_idx_${fldnames}";
				$SQL .= ",\n$idxtype index $idx_name($fields)";
			}
		}
	}
}

	$SQL .= ")\n";
	if ($dbms ne 'CSV' && $this->{option}->{TABOPT}) {
		foreach my $stmt (@{$this->{option}->{TABOPT}}) {
			if (! $stmt->{subtype} ||
					($stmt->{subtype} eq $dbms &&
					$stmt->{subtype} ne "!$dbms")) {
				$SQL .= "$stmt->{content}";
			}
		}
	}
	$SQL .= $sql_generator->table_options();
	$SQL .= ' ' . $optMergeTable;
print STDERR "SQL :: $SQL\n" if ($main::DEBUG);
	push(@SQL, $SQL);

if (0) {
	if (!$opt->{temporal} && $dbms ne 'CSV' && $this->{option}->{INDEX}) {
		foreach my $stmt (@{$this->{option}->{INDEX}}) {
			if (! $stmt->{subtype} ||
					($stmt->{subtype} eq $dbms &&
					$stmt->{subtype} ne "!$dbms")) {
				my ($idxtype, $fields) =
					($stmt->{content} =~ /(\w*)\((.*)\)/);
				my $fldnames = $fields;
				$fldnames =~ s/\s*,\s*/_/g;
				$idx_name = "${tablename}_idx_${fldnames}";
$SQL = "create $idxtype index $idx_name on $tablename ($fields)\n";
				push(@SQL, $SQL);
			}
		}
	}
}
print STDERR  join("\n",@SQL),"\n";
	@SQL;
}

sub identifier {
	my($this) = @_;
	return $this->{identifier};
}
sub primary_key {
	my($this) = @_;
	return @{$this->{option}->{PRIMKEY}};
}
sub foreign_key {
	my($this, $class) = @_;
	$class = &get_schema_classname($class);
	foreach $attr (@{$this->{attrlist}}) {
		return $attr if (&get_schema_classname(
				$this->{foreign}->{$attr}) eq $class);
	}
	return '';
}
sub get_numattr {
	my($this, $opt) = @_;
	return 0 + $this->get_attributes($opt);
}
sub set_mask {
	my($this, $maskattr, $opt) = @_;
	foreach my $attr (@{$this->{attrlist}}) {
		if (grep($attr eq $_, @{$maskattr})) {
			$this->{attr}->{$attr}->{mask_for_insert} = 1;
		}
	}
}
sub has_coltype {
	my($this, $type) = @_;
	foreach my $attr (@{$this->{attrlist}}) {
		if ($this->{attr}->{$attr}->{type} eq $type) {
			return 1;
		}
	}
	return 0;
}
sub get_type {
	my($this, $attr) = @_;
	return $this->{attr}->{$attr}->{type};
}
sub get_attributes {
	my($this, $opt) = @_;
	if ($opt->{for_insert} || $opt->{for_update}) {
		my(@tmplist);
		foreach my $attr (@{$this->{attrlist}}) {
			if ($opt->{for_insert} &&
				$this->{attr}->{$attr}->{mask_for_insert}) {
				### SKIP
			} elsif ($opt->{for_update} &&
				  ($this->{attr}->{$attr}->{mask_for_insert} ||
				  grep($attr eq $_, $this->primary_key)) ) {
				### SKIP
			} elsif ($opt->{ignore_ref} &&
					$this->{foreign}->{$attr}) {
				### SKIP
			} elsif ($opt->{skip_text} &&
				$this->{attr}->{$attr}->{type} eq 'text') {
				### SKIP
			} else {
				push(@tmplist, $attr);
			}
		} 
		return @tmplist;
	} else {
		return @{$this->{attrlist}};
	}
}
sub exists {
	my($this, $attr) = @_;
	return defined $this->{attr}->{$attr};
}

sub get_schema_path {
	my($class, $dbname) = @_;
	my($filename);

    #
	$class = &get_schema_classname($class);

    # remove UID
    my($dbname_nouid) = $dbname;
    $dbname_nouid =~ s#\_\d+\_\d+$##;

    #
	foreach $d ($dbname, $dbname_nouid, 'user', 'base') {
		if (-f "$MBGD::Config{schema_dir}/$d/$class.schema") {
			return "$MBGD::Config{schema_dir}/$d/$class.schema";
		}
	}
	if (-f "$MBGD::Config{schema_dir}/$class.schema") {
		return "$MBGD::Config{schema_dir}/$class.schema";
	}
	return '';
}
sub get_schema_classname {
	my($class) = @_;
	my($classname);
	if ($classname = ref($class)) {
	} else {
		$classname = $class;
	}
	$classname =~ s/^.*:://;
	$classname =~ tr/A-Z/a-z/;
	$classname;
}
sub read_types {
	open(F, "$MBGD::Config{schema_dir}/types.def") || return;
	while (<F>) {
		($type, $def) = split(/\t/);
		$Types{$type} = $def;
	}
	close(F);
}

sub find_composite_path {
	my($this, $class) = @_;
print "$this->{classname},>$class<\n";
	foreach my $cl (keys %{$this->{option}->{COMPOSITE}}) {
		$schema = MBGD::Schema->new($cl);
print "$schema->{classname},  $class\n";
		if ($schema->{classname} eq $class) {
			return $cl;
		}
		my @Path = $schema->find_composite_path($class);
		return ($cl, @Path) if (@Path);
	}
print ">>$this->{classname}<<<\n";
}
sub get_join_field {
	my($this, @schemas) = @_;
	my(@joinfields);
	my($ClassNames) = {$this->{classname}=>1};
	foreach $scm (@schemas) {
		$ClassNames->{$scm->{classname}} = 1;
	}
	foreach my $key (keys %{$this->{foreign}}) {
		my $class2 = &get_schema_classname($this->{foreign}->{$key});
		next if (! $ClassNames->{$class2});
		$REF{$this->{classname}, $class2} = 1;
		push(@joinfields, "$this->{classname}\.$key = $class2\.id");
	}
	foreach my $scm (@schemas) {
		my $class1 = &get_schema_classname($scm->{perl_classname});
		foreach my $key (keys %{$scm->{foreign}}) {
			my $class2 = &get_schema_classname($scm->{foreign}->{$key});
			next if (! $ClassNames->{$class1});
			next if (! $ClassNames->{$class2});

			$REF{"$class1:$class2"} = 1;
			push(@joinfields, "$class1\.$key = $class2\.id");
		}
	}
	@joinfields;
}

if (__FILE__ eq $0) {
	$genome = MBGD::Schema->new("MBGD::Genome");
	$gene = MBGD::Schema->new("MBGD::Gene");
	$geneseq = MBGD::Schema->new("MBGD::GeneSeq");
#	$protein = MBGD::Schema->new("MBGD::ProteinSeq");
#	@join = $gene->get_join_field($geneseq, $protein);
	@path = $genome->find_composite_path('gene');
	print join(' and ', @path), "\n";
}

1;
